/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risesoft.api.itemadmin.BookMarkBindApi;
import net.risesoft.entity.BookMarkBind;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.BookMarkBindService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services/rest/bookMarkBind"}, produces={"application/json"})
public class BookMarkBindApiImpl
implements BookMarkBindApi {
    private final JdbcTemplate jdbcTemplate;
    private final BookMarkBindService bookMarkBindService;

    public BookMarkBindApiImpl(@Qualifier(value="jdbcTemplate4Tenant") JdbcTemplate jdbcTemplate, BookMarkBindService bookMarkBindService) {
        this.jdbcTemplate = jdbcTemplate;
        this.bookMarkBindService = bookMarkBindService;
    }

    public Y9Result<Map<String, Object>> getBookMarkData(@RequestParam String tenantId, @RequestParam String wordTemplateId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Map map = new HashMap(16);
        List<BookMarkBind> bookMarkBindList = this.bookMarkBindService.listByWordTemplateId(wordTemplateId);
        if (!bookMarkBindList.isEmpty()) {
            String tableName = bookMarkBindList.get(0).getTableName();
            String columnName = "";
            for (BookMarkBind boorMark : bookMarkBindList) {
                if (StringUtils.isBlank((CharSequence)columnName)) {
                    columnName = boorMark.getColumnName() + " AS " + boorMark.getBookMarkName();
                    continue;
                }
                columnName = columnName + "," + boorMark.getColumnName() + " AS " + boorMark.getBookMarkName();
            }
            String sql = "SELECT " + columnName + " FROM " + tableName + " WHERE GUID='" + processSerialNumber + "'";
            map = this.jdbcTemplate.queryForMap(sql);
        }
        return Y9Result.success(map);
    }
}

