/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.api.itemadmin.position.AssociatedFile4PositionApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.model.itemadmin.AssociatedFileModel;
import net.risesoft.model.platform.Position;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.AssociatedFileService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/services/rest/associatedFile4Position"}, produces={"application/json"})
public class AssociatedFileApiImpl
implements AssociatedFile4PositionApi {
    private final AssociatedFileService associatedFileService;
    private final PositionApi positionManager;

    public Y9Result<Integer> countAssociatedFile(@RequestParam @NotBlank String tenantId, @RequestParam @NotBlank String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        int num = this.associatedFileService.countAssociatedFile(processSerialNumber);
        return Y9Result.success((Object)num);
    }

    public Y9Result<Object> deleteAllAssociatedFile(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam String delIds) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.associatedFileService.deleteAllAssociatedFile(processSerialNumber, delIds);
        return Y9Result.success();
    }

    public Y9Result<Object> deleteAssociatedFile(@RequestParam String tenantId, @RequestParam String processSerialNumber, @RequestParam String delId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        this.associatedFileService.deleteAssociatedFile(processSerialNumber, delId);
        return Y9Result.success();
    }

    public Y9Result<List<AssociatedFileModel>> getAssociatedFileAllList(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processSerialNumber) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        List<AssociatedFileModel> list = this.associatedFileService.listAssociatedFileAll(processSerialNumber);
        return Y9Result.success(list, (String)"\u83b7\u53d6\u6210\u529f");
    }

    public Y9Result<Object> saveAssociatedFile(@RequestParam String tenantId, @RequestParam String positionId, @RequestParam String processSerialNumber, @RequestParam String processInstanceIds) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Position position = (Position)this.positionManager.get(tenantId, positionId).getData();
        Y9LoginUserHolder.setPosition((Position)position);
        this.associatedFileService.saveAssociatedFile(processSerialNumber, processInstanceIds);
        return Y9Result.success();
    }

    @Generated
    public AssociatedFileApiImpl(AssociatedFileService associatedFileService, PositionApi positionManager) {
        this.associatedFileService = associatedFileService;
        this.positionManager = positionManager;
    }
}

