/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.json.Y9JsonUtil;
import org.javers.core.Changes;
import org.javers.core.Javers;
import org.javers.core.changelog.ChangeProcessor;
import org.javers.core.changelog.SimpleTextChangeLog;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/history"})
public class HistoryController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryController.class);
    private final Javers javers;

    @RequestMapping(value={"/changes"}, produces={"text/plain"})
    public Y9Result<String> getEntityChanges(@RequestParam String entity, @RequestParam Optional<Object> id, @RequestParam Optional<String> author) {
        QueryBuilder jqlQuery = null;
        if (id.isPresent()) {
            jqlQuery = QueryBuilder.byInstanceId(id, (String)entity);
        } else {
            try {
                this.getClass();
                Class<?> clz = Class.forName(entity);
                jqlQuery = QueryBuilder.byClass((Class[])new Class[]{clz});
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        jqlQuery = author.isPresent() ? jqlQuery.byAuthor(author.get()) : jqlQuery;
        Changes changes = this.javers.findChanges(jqlQuery.build());
        String changeLog = (String)this.javers.processChangeList((List)changes, (ChangeProcessor)new SimpleTextChangeLog());
        changeLog.replaceAll("\n", "<br>");
        return Y9Result.success((Object)changeLog);
    }

    @RequestMapping(value={"/shadows"})
    public Y9Result<List<Object>> getEntityShadows(@RequestParam String entity, @RequestParam Optional<Object> id, @RequestParam Optional<String> author) {
        QueryBuilder jqlQuery = null;
        if (id.isPresent()) {
            jqlQuery = QueryBuilder.byInstanceId(id, (String)entity);
        } else {
            try {
                this.getClass();
                Class<?> clz = Class.forName(entity);
                jqlQuery = QueryBuilder.byClass((Class[])new Class[]{clz});
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        jqlQuery = author.isPresent() ? jqlQuery.byAuthor(author.get()) : jqlQuery;
        List shadows = this.javers.findShadows(jqlQuery.build());
        ArrayList<Object> rows = new ArrayList<Object>();
        for (Shadow s : shadows) {
            rows.add(s.get());
        }
        return Y9Result.success(rows);
    }

    @RequestMapping(value={"/getShadowRows"})
    public Y9Result<List<Map<String, Object>>> getEntityShadowsRows(@RequestParam String entity, @RequestParam Optional<String> id, @RequestParam Optional<String> author) throws ClassNotFoundException {
        QueryBuilder jqlQuery = null;
        this.getClass();
        jqlQuery = id.isPresent() ? QueryBuilder.byInstanceId((Object)id.get(), (String)entity) : QueryBuilder.byClass((Class[])new Class[]{Class.forName(entity)});
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        jqlQuery = author.isPresent() ? jqlQuery.byAuthor(author.get()) : jqlQuery;
        List snapshots = this.javers.findSnapshots(jqlQuery.build());
        snapshots.sort((o1, o2) -> -1 * o1.getCommitMetadata().getCommitDate().compareTo(o2.getCommitMetadata().getCommitDate()));
        HashMap map = new HashMap();
        JsonConverter jsonConverter = this.javers.getJsonConverter();
        ArrayList<HashMap> columns = new ArrayList<HashMap>();
        for (CdoSnapshot shot : snapshots) {
            CdoSnapshotState state = shot.getState();
            CommitMetadata commit = shot.getCommitMetadata();
            String json = jsonConverter.toJson((Object)state);
            map = Y9JsonUtil.readHashMap((String)json, String.class, Object.class);
            map.put("commitAuthor", "\u4fee\u6539\u65f6\u95f4\uff1a" + commit.getCommitDate().format(sdf) + "  \u4fee\u6539\u4eba\u5458\uff1a" + commit.getProperties().getOrDefault("authorName", " ") + "(IP:" + commit.getProperties().getOrDefault("hostIp", "\u65e0") + ")");
            columns.add(map);
        }
        return Y9Result.success(columns);
    }

    @RequestMapping(value={"/snapshots"})
    public Y9Result<List<CdoSnapshot>> getEntitySnapshots(@RequestParam String entity, @RequestParam Optional<Object> id, @RequestParam Optional<String> author) {
        QueryBuilder jqlQuery = null;
        if (id.isPresent()) {
            jqlQuery = QueryBuilder.byInstanceId(id, (String)entity);
        } else {
            try {
                this.getClass();
                Class<?> clz = Class.forName(entity);
                jqlQuery = QueryBuilder.byClass((Class[])new Class[]{clz});
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        jqlQuery = author.isPresent() ? jqlQuery.byAuthor(author.get()) : jqlQuery;
        List snapshots = this.javers.findSnapshots(jqlQuery.build());
        snapshots.sort((o1, o2) -> -1 * o1.getCommitMetadata().getCommitDate().compareTo(o2.getCommitMetadata().getCommitDate()));
        return Y9Result.success((Object)snapshots);
    }

    @RequestMapping(value={"/getShadowTitles"})
    public Y9Result<Set<String>> getShadowTitles(@RequestParam String entity, @RequestParam Optional<Object> id, @RequestParam Optional<String> author) {
        HashSet titles = new HashSet();
        try {
            Optional snapshot = this.javers.getLatestSnapshot(id.orElse(null), Class.forName(entity));
            if (snapshot.isPresent()) {
                CdoSnapshotState state = ((CdoSnapshot)snapshot.get()).getState();
                titles.addAll(state.getPropertyNames());
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return Y9Result.success(titles);
    }

    @Generated
    public HistoryController(Javers javers) {
        this.javers = javers;
    }
}

