/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.config;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.risesoft.model.user.UserInfo;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class HistoryConfig {
    @Bean
    public AuthorProvider authorProvider() {
        return new AuthorProvider(){

            public String provide() {
                UserInfo userInfo = Y9LoginUserHolder.getUserInfo();
                if (userInfo != null) {
                    String author = userInfo.getPersonId();
                    return author;
                }
                return "";
            }
        };
    }

    @Bean
    public CommitPropertiesProvider commitPropertiesProvider() {
        return new CommitPropertiesProvider(){

            public Map<String, String> provide() {
                HashMap<String, String> map = new HashMap<String, String>();
                String tenantId = Y9LoginUserHolder.getTenantId();
                String deptId = Y9LoginUserHolder.getDeptId();
                map.put("tenantId", tenantId);
                map.put("deptId", deptId);
                String userHostIp = "";
                try {
                    UserInfo userInfo;
                    ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                    if (sra != null) {
                        HttpServletRequest request = sra.getRequest();
                        userHostIp = Y9Context.getIpAddr((HttpServletRequest)request);
                        if (userHostIp != null && userHostIp.contains(":")) {
                            userHostIp = "127.0.0.1";
                        }
                        map.put("hostIp", userHostIp);
                    }
                    if ((userInfo = Y9LoginUserHolder.getUserInfo()) != null) {
                        map.put("authorName", userInfo.getName());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return map;
            }
        };
    }
}

