/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.service.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import lombok.Generated;
import net.risesoft.enums.FileStoreTypeEnum;
import net.risesoft.y9.configuration.feature.file.rest.Y9RestFileProperties;
import net.risesoft.y9public.service.StoreService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class RestStoreServiceImpl
implements StoreService {
    private final Y9RestFileProperties y9RestFileProperties;

    public void deleteFile(String fullPath, String realFileName) throws Exception {
        String fileManagerUrl = this.y9RestFileProperties.getFileManagerUrl();
        String destination = fileManagerUrl + "/rest/deleteFile";
        HttpRequest httpRequest = (HttpRequest)HttpRequest.post((String)destination).form("fullPath", (Object)fullPath, new Object[]{"fileName", realFileName});
        HttpResponse httpResponse = httpRequest.send();
        httpResponse.close();
    }

    public FileStoreTypeEnum getStoreType() {
        return FileStoreTypeEnum.REST;
    }

    public byte[] retrieveFileBytes(String fullPath, String realFileName) throws Exception {
        String fileManagerUrl = this.y9RestFileProperties.getFileManagerUrl();
        String destination = fileManagerUrl + "/rest/retrieveFileStream";
        HttpRequest httpRequest = (HttpRequest)HttpRequest.post((String)destination).form("fullPath", (Object)fullPath, new Object[]{"fileName", realFileName});
        HttpResponse httpResponse = httpRequest.send();
        byte[] bytes = httpResponse.bodyBytes();
        httpResponse.close();
        return bytes;
    }

    public void retrieveFileStream(String fullPath, String realFileName, OutputStream outputStream) throws Exception {
        byte[] bytes = this.retrieveFileBytes(fullPath, realFileName);
        IOUtils.write((byte[])bytes, (OutputStream)outputStream);
    }

    public void storeFile(String fullPath, String realFileName, byte[] bytes) throws Exception {
        String tempDir = System.getProperty("java.io.tmpdir");
        File tempFile = new File(tempDir, realFileName);
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])bytes);
        String fileManagerUrl = this.y9RestFileProperties.getFileManagerUrl();
        String destination = fileManagerUrl + "/rest/storeFile";
        HttpRequest httpRequest = (HttpRequest)HttpRequest.post((String)destination).form("fullPath", (Object)fullPath, new Object[]{"fileName", realFileName, "multipartFile", tempFile});
        HttpResponse httpResponse = httpRequest.send();
        httpResponse.close();
        tempFile.delete();
    }

    public void storeFile(String fullPath, String realFileName, InputStream inputStream) throws Exception {
        this.storeFile(fullPath, realFileName, IOUtils.toByteArray((InputStream)inputStream));
    }

    @Generated
    public RestStoreServiceImpl(Y9RestFileProperties y9RestFileProperties) {
        this.y9RestFileProperties = y9RestFileProperties;
    }
}

