/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.service.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;
import net.risesoft.enums.FileStoreTypeEnum;
import net.risesoft.y9.configuration.feature.file.local.Y9LocalProperties;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.service.StoreService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LocalStoreServiceImpl
implements StoreService {
    private final Y9LocalProperties y9LocalProperties;

    public void deleteFile(String fullPath, String realFileName) throws Exception {
        File file = new File(Y9FileStore.buildPath((String[])new String[]{this.y9LocalProperties.getBasePath(), fullPath}), realFileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public FileStoreTypeEnum getStoreType() {
        return FileStoreTypeEnum.LOCAL;
    }

    public byte[] retrieveFileBytes(String fullPath, String realFileName) throws Exception {
        File file = new File(Y9FileStore.buildPath((String[])new String[]{this.y9LocalProperties.getBasePath(), fullPath}), realFileName);
        if (file.exists()) {
            return FileUtils.readFileToByteArray((File)file);
        }
        return new byte[0];
    }

    public void retrieveFileStream(String fullPath, String realFileName, OutputStream outputStream) throws Exception {
        IOUtils.write((byte[])this.retrieveFileBytes(fullPath, realFileName), (OutputStream)outputStream);
    }

    public void storeFile(String fullPath, String realFileName, byte[] bytes) throws Exception {
        File parentFolder = new File(Y9FileStore.buildPath((String[])new String[]{this.y9LocalProperties.getBasePath(), fullPath}));
        parentFolder.mkdirs();
        File newFile = new File(parentFolder, realFileName);
        FileUtils.writeByteArrayToFile((File)newFile, (byte[])bytes);
    }

    public void storeFile(String fullPath, String realFileName, InputStream inputStream) throws Exception {
        this.storeFile(fullPath, realFileName, IOUtils.toByteArray((InputStream)inputStream));
    }

    @Generated
    public LocalStoreServiceImpl(Y9LocalProperties y9LocalProperties) {
        this.y9LocalProperties = y9LocalProperties;
    }
}

