/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.service.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Date;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import lombok.Generated;
import net.risesoft.id.IdType;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.feature.file.Y9FileProperties;
import net.risesoft.y9.util.crypto.AesUtil;
import net.risesoft.y9.util.crypto.RsaUtil;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.repository.Y9FileStoreRepository;
import net.risesoft.y9public.service.StoreService;
import net.risesoft.y9public.service.Y9FileStoreService;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure1;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure11;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure13;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure15;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure17;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure19;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure21;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure23;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure25;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure27;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure29;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure3;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure31;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure33;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure35;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure5;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure7;
import net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl$AjcClosure9;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.aspectj.AnnotationTransactionAspect;
import org.springframework.web.multipart.MultipartFile;

@Service(value="y9FileStoreService")
@Transactional(rollbackFor={Exception.class}, transactionManager="rsPublicTransactionManager")
public class Y9FileStoreServiceImpl
implements Y9FileStoreService {
    @Generated
    private static final Logger LOGGER;
    private final Y9FileStoreRepository y9FileStoreRepository;
    private final Y9FileProperties y9FileProperties;
    private final StoreService storeService;
    private final ThreadPoolTaskExecutor taskExecutor;
    private boolean encryptionFileContent = false;
    private String privateKey = "";
    private String publicKey = "";
    private String prefix = "";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;

    private String buildFullPath(String prefix, String customPath) {
        LocalDate localDate = LocalDate.now();
        String datePath = Y9FileStore.buildPath(String.valueOf(localDate.getYear()), String.valueOf(localDate.getMonthValue()), String.valueOf(localDate.getDayOfMonth()));
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            return Y9FileStore.buildPath(prefix, datePath, customPath);
        }
        return Y9FileStore.buildPath(datePath, customPath);
    }

    private boolean decryptionRequired(Y9FileStore y9FileStore) {
        return this.encryptionFileContent && StringUtils.isNotBlank((CharSequence)y9FileStore.getFileEnvelope());
    }

    @Override
    public boolean deleteFile(String id) {
        String string = id;
        Object[] objectArray = new Object[]{this, string};
        return Conversions.booleanValue((Object)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure1(objectArray), ajc$tjp_0));
    }

    @Override
    public byte[] downloadFileToBytes(String id) throws Exception {
        String string = id;
        Object[] objectArray = new Object[]{this, string};
        return (byte[])AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure3(objectArray), ajc$tjp_1);
    }

    @Override
    public void downloadFileToOutputStream(String id, OutputStream outputStream) throws Exception {
        String string = id;
        OutputStream outputStream2 = outputStream;
        Object[] objectArray = new Object[]{this, string, outputStream2};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure5(objectArray), ajc$tjp_2);
    }

    @Override
    public String downloadFileToString(String id) throws Exception {
        String string = id;
        Object[] objectArray = new Object[]{this, string};
        return (String)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure7(objectArray), ajc$tjp_3);
    }

    @Override
    public Y9FileStore getById(String y9FileStoreId) {
        String string = y9FileStoreId;
        Object[] objectArray = new Object[]{this, string};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure9(objectArray), ajc$tjp_4);
    }

    @PostConstruct
    public void init() {
        Object[] objectArray = new Object[]{this};
        AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure11(objectArray), ajc$tjp_5);
    }

    private Y9FileStore saveY9FileStore(String customPath, String fileName, String fileEnvelope, long fileSize) {
        Y9FileStore y9FileStore = new Y9FileStore();
        String y9FileStoreId = Y9IdGenerator.genId((IdType)IdType.SNOWFLAKE);
        y9FileStore.setId(y9FileStoreId);
        y9FileStore.setPrefix(this.prefix);
        y9FileStore.setSystemName(Y9Context.getSystemName());
        y9FileStore.setTenantId(Y9LoginUserHolder.getTenantId());
        if (Y9LoginUserHolder.getUserInfo() != null) {
            y9FileStore.setUploader(Y9LoginUserHolder.getUserInfo().getName());
        }
        y9FileStore.setUploadTime(new Date());
        y9FileStore.setFullPath(this.buildFullPath(this.prefix, customPath));
        y9FileStore.setFileName(fileName);
        String fileExt = FilenameUtils.getExtension((String)fileName);
        String realFileName = y9FileStoreId + "." + fileExt;
        String url = "/files/" + realFileName;
        y9FileStore.setStoreType(this.storeService.getStoreType());
        y9FileStore.setFileExt(fileExt);
        y9FileStore.setRealFileName(realFileName);
        y9FileStore.setFileSize(fileSize);
        y9FileStore.setUrl(url);
        y9FileStore.setFileEnvelope(fileEnvelope);
        return (Y9FileStore)this.y9FileStoreRepository.save(y9FileStore);
    }

    @Override
    public Y9FileStore uploadFile(byte[] bytes, String customPath, String fileName) throws Exception {
        byte[] byArray = bytes;
        String string = customPath;
        String string2 = fileName;
        Object[] objectArray = new Object[]{this, byArray, string, string2};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure13(objectArray), ajc$tjp_6);
    }

    @Override
    public Y9FileStore uploadFile(File file, String customPath, String fileName) throws Exception {
        File file2 = file;
        String string = customPath;
        String string2 = fileName;
        Object[] objectArray = new Object[]{this, file2, string, string2};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure15(objectArray), ajc$tjp_7);
    }

    @Override
    public Y9FileStore uploadFile(InputStream inputStream, String customPath, String fileName) throws Exception {
        InputStream inputStream2 = inputStream;
        String string = customPath;
        String string2 = fileName;
        Object[] objectArray = new Object[]{this, inputStream2, string, string2};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure17(objectArray), ajc$tjp_8);
    }

    @Override
    public Y9FileStore uploadFile(MultipartFile multipartFile, String customPath, String fileName) throws Exception {
        MultipartFile multipartFile2 = multipartFile;
        String string = customPath;
        String string2 = fileName;
        Object[] objectArray = new Object[]{this, multipartFile2, string, string2};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure19(objectArray), ajc$tjp_9);
    }

    @Override
    public Y9FileStore uploadFileAsync(byte[] bytes, String customPath, String fileName) throws Exception {
        byte[] byArray = bytes;
        String string = customPath;
        String string2 = fileName;
        Object[] objectArray = new Object[]{this, byArray, string, string2};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure21(objectArray), ajc$tjp_10);
    }

    @Override
    public Y9FileStore uploadFileAsync(File file, String customPath, String fileName) throws Exception {
        File file2 = file;
        String string = customPath;
        String string2 = fileName;
        Object[] objectArray = new Object[]{this, file2, string, string2};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure23(objectArray), ajc$tjp_11);
    }

    @Override
    public Y9FileStore uploadFileAsync(InputStream inputStream, String customPath, String fileName) throws Exception {
        InputStream inputStream2 = inputStream;
        String string = customPath;
        String string2 = fileName;
        Object[] objectArray = new Object[]{this, inputStream2, string, string2};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure25(objectArray), ajc$tjp_12);
    }

    @Override
    public Y9FileStore uploadFileAsync(MultipartFile multipartFile, String customPath, String fileName) throws Exception {
        MultipartFile multipartFile2 = multipartFile;
        String string = customPath;
        String string2 = fileName;
        Object[] objectArray = new Object[]{this, multipartFile2, string, string2};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure27(objectArray), ajc$tjp_13);
    }

    @Override
    public Y9FileStore uploadFileReplace(byte[] bytes, String y9FileStoreId) throws Exception {
        byte[] byArray = bytes;
        String string = y9FileStoreId;
        Object[] objectArray = new Object[]{this, byArray, string};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure29(objectArray), ajc$tjp_14);
    }

    @Override
    public Y9FileStore uploadFileReplace(File file, String y9FileStoreId) throws Exception {
        File file2 = file;
        String string = y9FileStoreId;
        Object[] objectArray = new Object[]{this, file2, string};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure31(objectArray), ajc$tjp_15);
    }

    @Override
    public Y9FileStore uploadFileReplace(InputStream inputStream, String y9FileStoreId) throws Exception {
        InputStream inputStream2 = inputStream;
        String string = y9FileStoreId;
        Object[] objectArray = new Object[]{this, inputStream2, string};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure33(objectArray), ajc$tjp_16);
    }

    @Override
    public Y9FileStore uploadFileReplace(MultipartFile multipartFile, String y9FileStoreId) throws Exception {
        MultipartFile multipartFile2 = multipartFile;
        String string = y9FileStoreId;
        Object[] objectArray = new Object[]{this, multipartFile2, string};
        return (Y9FileStore)AnnotationTransactionAspect.aspectOf().ajc$around$org_springframework_transaction_aspectj_AbstractTransactionAspect$1$2a73e96c((Object)this, (AroundClosure)new Y9FileStoreServiceImpl$AjcClosure35(objectArray), ajc$tjp_17);
    }

    @Generated
    public Y9FileStoreServiceImpl(Y9FileStoreRepository y9FileStoreRepository, Y9FileProperties y9FileProperties, StoreService storeService, ThreadPoolTaskExecutor taskExecutor) {
        this.y9FileStoreRepository = y9FileStoreRepository;
        this.y9FileProperties = y9FileProperties;
        this.storeService = storeService;
        this.taskExecutor = taskExecutor;
    }

    static {
        Y9FileStoreServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(Y9FileStoreServiceImpl.class);
    }

    static final /* synthetic */ boolean deleteFile_aroundBody0(Y9FileStoreServiceImpl ajc$this, String id) {
        Y9FileStore y9FileStore = ajc$this.getById(id);
        if (null != y9FileStore) {
            try {
                ajc$this.storeService.deleteFile(y9FileStore.getFullPath(), y9FileStore.getRealFileName());
                ajc$this.y9FileStoreRepository.deleteById(id);
                return true;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    static final /* synthetic */ byte[] downloadFileToBytes_aroundBody2(Y9FileStoreServiceImpl ajc$this, String id) {
        Y9FileStore y9FileStore = ajc$this.getById(id);
        byte[] bytes = ajc$this.storeService.retrieveFileBytes(y9FileStore.getFullPath(), y9FileStore.getRealFileName());
        if (ajc$this.decryptionRequired(y9FileStore)) {
            try {
                String key = RsaUtil.decryptByPubKey((String)y9FileStore.getFileEnvelope(), (String)ajc$this.publicKey);
                bytes = AesUtil.decryptByte((byte[])bytes, (String)key);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return bytes;
    }

    static final /* synthetic */ void downloadFileToOutputStream_aroundBody4(Y9FileStoreServiceImpl ajc$this, String id, OutputStream outputStream) {
        Y9FileStore y9FileStore = ajc$this.getById(id);
        if (ajc$this.decryptionRequired(y9FileStore)) {
            try {
                String key = RsaUtil.decryptByPubKey((String)y9FileStore.getFileEnvelope(), (String)ajc$this.publicKey);
                ajc$this.storeService.retrieveFileStream(y9FileStore.getFullPath(), y9FileStore.getRealFileName(), AesUtil.decryptStream((String)key, (OutputStream)outputStream));
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        } else {
            ajc$this.storeService.retrieveFileStream(y9FileStore.getFullPath(), y9FileStore.getRealFileName(), outputStream);
        }
    }

    static final /* synthetic */ String downloadFileToString_aroundBody6(Y9FileStoreServiceImpl ajc$this, String id) {
        byte[] bytes = ajc$this.downloadFileToBytes(id);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static final /* synthetic */ Y9FileStore getById_aroundBody8(Y9FileStoreServiceImpl ajc$this, String y9FileStoreId) {
        return ajc$this.y9FileStoreRepository.findById(y9FileStoreId).orElse(null);
    }

    static final /* synthetic */ void init_aroundBody10(Y9FileStoreServiceImpl ajc$this) {
        ajc$this.encryptionFileContent = ajc$this.y9FileProperties.isEncryptionFileContent();
        ajc$this.privateKey = ajc$this.y9FileProperties.getPrivateKey();
        ajc$this.publicKey = ajc$this.y9FileProperties.getPublicKey();
        ajc$this.prefix = ajc$this.y9FileProperties.getPrefix();
    }

    static final /* synthetic */ Y9FileStore uploadFile_aroundBody12(Y9FileStoreServiceImpl ajc$this, byte[] bytes, String customPath, String fileName) {
        return ajc$this.uploadFile(new ByteArrayInputStream(bytes), customPath, fileName);
    }

    static final /* synthetic */ Y9FileStore uploadFile_aroundBody14(Y9FileStoreServiceImpl ajc$this, File file, String customPath, String fileName) {
        return ajc$this.uploadFile(new FileInputStream(file), customPath, fileName);
    }

    static final /* synthetic */ Y9FileStore uploadFile_aroundBody16(Y9FileStoreServiceImpl ajc$this, InputStream inputStream, String customPath, String fileName) {
        int fileSize = inputStream.available();
        String fileEnvelope = null;
        if (ajc$this.encryptionFileContent) {
            try {
                String aesKey = AesUtil.getSecretKey();
                fileEnvelope = RsaUtil.encryptByPriKey((String)aesKey, (String)ajc$this.privateKey);
                inputStream = AesUtil.encryptStream((String)aesKey, (InputStream)inputStream);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        Y9FileStore y9FileStore = ajc$this.saveY9FileStore(customPath, fileName, fileEnvelope, fileSize);
        ajc$this.storeService.storeFile(y9FileStore.getFullPath(), y9FileStore.getRealFileName(), inputStream);
        return y9FileStore;
    }

    static final /* synthetic */ Y9FileStore uploadFile_aroundBody18(Y9FileStoreServiceImpl ajc$this, MultipartFile multipartFile, String customPath, String fileName) {
        return ajc$this.uploadFile(multipartFile.getInputStream(), customPath, fileName);
    }

    static final /* synthetic */ Y9FileStore uploadFileAsync_aroundBody20(Y9FileStoreServiceImpl ajc$this, byte[] bytes, String customPath, String fileName) {
        return ajc$this.uploadFileAsync(new ByteArrayInputStream(bytes), customPath, fileName);
    }

    static final /* synthetic */ Y9FileStore uploadFileAsync_aroundBody22(Y9FileStoreServiceImpl ajc$this, File file, String customPath, String fileName) {
        return ajc$this.uploadFileAsync(new FileInputStream(file), customPath, fileName);
    }

    static final /* synthetic */ Y9FileStore uploadFileAsync_aroundBody24(Y9FileStoreServiceImpl ajc$this, InputStream inputStream, String customPath, String fileName) {
        int fileSize = inputStream.available();
        String fileEnvelope = null;
        if (ajc$this.encryptionFileContent) {
            try {
                String aesKey = AesUtil.getSecretKey();
                fileEnvelope = RsaUtil.encryptByPriKey((String)aesKey, (String)ajc$this.privateKey);
                inputStream = AesUtil.encryptStream((String)aesKey, (InputStream)inputStream);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        Y9FileStore y9FileStore = ajc$this.saveY9FileStore(customPath, fileName, fileEnvelope, fileSize);
        InputStream finalInputStream = inputStream;
        Future submit = ajc$this.taskExecutor.submit(() -> {
            try {
                this.storeService.storeFile(y9FileStore.getFullPath(), y9FileStore.getRealFileName(), finalInputStream);
                return Boolean.TRUE;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                return Boolean.FALSE;
            }
        });
        return (Y9FileStore)ajc$this.y9FileStoreRepository.save(y9FileStore);
    }

    static final /* synthetic */ Y9FileStore uploadFileAsync_aroundBody26(Y9FileStoreServiceImpl ajc$this, MultipartFile multipartFile, String customPath, String fileName) {
        return ajc$this.uploadFileAsync(multipartFile.getInputStream(), customPath, fileName);
    }

    static final /* synthetic */ Y9FileStore uploadFileReplace_aroundBody28(Y9FileStoreServiceImpl ajc$this, byte[] bytes, String y9FileStoreId) {
        return ajc$this.uploadFileReplace(new ByteArrayInputStream(bytes), y9FileStoreId);
    }

    static final /* synthetic */ Y9FileStore uploadFileReplace_aroundBody30(Y9FileStoreServiceImpl ajc$this, File file, String y9FileStoreId) {
        return ajc$this.uploadFileReplace(new FileInputStream(file), y9FileStoreId);
    }

    static final /* synthetic */ Y9FileStore uploadFileReplace_aroundBody32(Y9FileStoreServiceImpl ajc$this, InputStream inputStream, String y9FileStoreId) {
        Y9FileStore y9FileStore = ajc$this.getById(y9FileStoreId);
        ajc$this.deleteFile(y9FileStoreId);
        return ajc$this.uploadFile(inputStream, y9FileStore.getFullPath(), y9FileStore.getFileName());
    }

    static final /* synthetic */ Y9FileStore uploadFileReplace_aroundBody34(Y9FileStoreServiceImpl ajc$this, MultipartFile multipartFile, String y9FileStoreId) {
        return ajc$this.uploadFileReplace(multipartFile.getInputStream(), y9FileStoreId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Y9FileStoreServiceImpl.java", Y9FileStoreServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteFile", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.lang.String", "id", "", "boolean"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "downloadFileToBytes", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.lang.String", "id", "java.lang.Exception", "[B"), 93);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFileAsync", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "[B:java.lang.String:java.lang.String", "bytes:customPath:fileName", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 210);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFileAsync", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.io.File:java.lang.String:java.lang.String", "file:customPath:fileName", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 215);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFileAsync", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.io.InputStream:java.lang.String:java.lang.String", "inputStream:customPath:fileName", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 220);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFileAsync", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "org.springframework.web.multipart.MultipartFile:java.lang.String:java.lang.String", "multipartFile:customPath:fileName", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 253);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFileReplace", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "[B:java.lang.String", "bytes:y9FileStoreId", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 258);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFileReplace", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.io.File:java.lang.String", "file:y9FileStoreId", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 263);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFileReplace", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.io.InputStream:java.lang.String", "inputStream:y9FileStoreId", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 268);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFileReplace", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "org.springframework.web.multipart.MultipartFile:java.lang.String", "multipartFile:y9FileStoreId", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 275);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "downloadFileToOutputStream", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.lang.String:java.io.OutputStream", "id:outputStream", "java.lang.Exception", "void"), 108);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "downloadFileToString", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.lang.String", "id", "java.lang.Exception", "java.lang.String"), 124);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getById", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.lang.String", "y9FileStoreId", "", "net.risesoft.y9public.entity.Y9FileStore"), 130);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "", "", "", "void"), 135);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFile", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "[B:java.lang.String:java.lang.String", "bytes:customPath:fileName", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 171);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFile", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.io.File:java.lang.String:java.lang.String", "file:customPath:fileName", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 176);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFile", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "java.io.InputStream:java.lang.String:java.lang.String", "inputStream:customPath:fileName", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 181);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uploadFile", "net.risesoft.y9public.service.impl.Y9FileStoreServiceImpl", "org.springframework.web.multipart.MultipartFile:java.lang.String:java.lang.String", "multipartFile:customPath:fileName", "java.lang.Exception", "net.risesoft.y9public.entity.Y9FileStore"), 205);
    }
}

