/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.controller;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.risesoft.exception.ErrorCode;
import net.risesoft.y9.util.Y9Assert;
import net.risesoft.y9.util.mime.ContentDispositionUtil;
import net.risesoft.y9.util.mime.MediaTypeUtils;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.exception.Y9FileErrorCodeEnum;
import net.risesoft.y9public.service.Y9FileStoreService;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class Y9FileController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9FileController.class);
    private final Y9FileStoreService y9FileStoreService;
    private final ServletContext servletContext;

    @RequestMapping(value={"/s/{realStoreFileName}"})
    public void download(@PathVariable String realStoreFileName, HttpServletResponse response) throws Exception {
        String id = FilenameUtils.getBaseName((String)realStoreFileName);
        Y9FileStore y9FileStore = this.y9FileStoreService.getById(id);
        Y9Assert.notNull((Object)y9FileStore, (ErrorCode)Y9FileErrorCodeEnum.FILE_NOT_FOUND, (Object[])new Object[]{id});
        try (ServletOutputStream out = response.getOutputStream();){
            response.setHeader("Content-disposition", ContentDispositionUtil.standardizeAttachment((String)y9FileStore.getFileName()));
            response.setContentType(MediaTypeUtils.getMediaTypeForFileName((ServletContext)this.servletContext, (String)y9FileStore.getFileName()).toString());
            this.y9FileStoreService.downloadFileToOutputStream(id, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/s"})
    public void download2(@RequestParam String realStoreFileName, HttpServletResponse response) throws Exception {
        this.download(realStoreFileName, response);
    }

    @RequestMapping(value={"/files/{realStoreFileName}"})
    public void downloadFiles(@PathVariable String realStoreFileName, HttpServletResponse response) throws Exception {
        this.download(realStoreFileName, response);
    }

    @Generated
    public Y9FileController(Y9FileStoreService y9FileStoreService, ServletContext servletContext) {
        this.y9FileStoreService = y9FileStoreService;
        this.servletContext = servletContext;
    }
}

