/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;
import net.risesoft.enums.FileStoreTypeEnum;
import net.risesoft.persistence.EnumConverter;
import net.risesoft.y9.util.Y9FileUtil;
import net.risesoft.y9public.support.FileNameConverter;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.Comment;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.util.StringUtils;

@Entity
@Table(name="Y9_COMMON_FILE_STORE")
@org.hibernate.annotations.Table(comment="\u6587\u4ef6\u4ed3\u5e93\u8868", appliesTo="Y9_COMMON_FILE_STORE")
public class Y9FileStore
implements Serializable {
    private static final long serialVersionUID = 5215025303846508704L;
    @Id
    @Column(name="STOREID", length=38)
    @Comment(value="\u4e3b\u952e")
    private String id;
    @Column(name="STORETYPE")
    @Comment(value="\u4ed3\u5e93\u7c7b\u578b")
    @Convert(converter=EnumConverter.FileStoreTypeEnumConverter.class)
    private FileStoreTypeEnum storeType = FileStoreTypeEnum.FTP;
    @Column(name="FULLPATH", length=300)
    @Comment(value="\u7edd\u5bf9\u8def\u5f84")
    private String fullPath;
    @Convert(converter=FileNameConverter.class)
    @Column(name="FILENAME", length=600)
    @Comment(value="\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u79f0")
    private String fileName;
    @Column(name="REALFILENAME", length=100, nullable=true)
    @Comment(value="\u5b58\u653e\u7684\u6587\u4ef6\u540d\u79f0")
    private String realFileName;
    @Column(name="FILESIZE", nullable=true)
    @ColumnDefault(value="0")
    @Comment(value="\u6587\u4ef6\u957f\u5ea6")
    private Long fileSize;
    @Column(name="FILESHA", length=200, nullable=true)
    @Comment(value="\u6587\u4ef6SHA\u503c")
    private String fileSha;
    @Column(name="FILEENVELOPE", length=200, nullable=true)
    @Comment(value="\u6587\u4ef6\u6570\u5b57\u4fe1\u5c01: \u5373AES\u7684\u968f\u673a\u5bc6\u94a5\uff0c\u7136\u540e\u8fdb\u884cRSA\u52a0\u5bc6\u540e\u7684\u7ed3\u679c")
    private String fileEnvelope;
    @Column(name="FILEEXT", length=50, nullable=true)
    @Comment(value="\u6587\u4ef6\u6269\u5c55\u540d\u79f0")
    private String fileExt;
    @Column(name="FILEURL", length=500)
    @Comment(value="\u5b8c\u6574\u7684\u6587\u4ef6\u5730\u5740")
    private String url;
    @Column(name="SYSTEMNAME", length=50)
    @Comment(value="\u7cfb\u7edf\u540d\u79f0")
    private String systemName;
    @Column(name="PREFIX", length=50)
    @Comment(value="\u6839\u76ee\u5f55\u524d\u7f00")
    private String prefix;
    @Column(name="TENANTID", length=38)
    @Comment(value="\u79df\u6237Id")
    private String tenantId;
    @Column(name="UPLOADER", length=100)
    @Comment(value="\u4e0a\u4f20\u4eba")
    private String uploader;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="UPLOADTIME")
    @Comment(value="\u4e0a\u4f20\u65f6\u95f4")
    private Date uploadTime;

    public static String buildPath(String ... paths) {
        StringBuilder sb = new StringBuilder();
        for (String path : paths) {
            if (!StringUtils.hasText((String)path)) continue;
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            sb.append("/").append(path);
        }
        return sb.toString();
    }

    public String getDisplayFileSize() {
        String displayFileSize = "0B";
        if (this.fileSize != null) {
            Y9FileUtil.getDisplayFileSize((long)this.fileSize);
        }
        return displayFileSize;
    }

    public String getFullPathAndFileName() {
        String fullName = this.fullPath;
        if (!fullName.endsWith("/")) {
            fullName = fullName + "/";
        }
        fullName = fullName + this.fileName;
        return fullName;
    }

    public String getFullPathAndRealFileName() {
        String fullName = this.fullPath;
        if (!fullName.endsWith("/")) {
            fullName = fullName + "/";
        }
        fullName = fullName + this.getRealFileName();
        return fullName;
    }

    @Generated
    public Y9FileStore() {
    }

    @Generated
    public String toString() {
        return "Y9FileStore(id=" + this.id + ", storeType=" + this.storeType + ", fullPath=" + this.fullPath + ", fileName=" + this.fileName + ", realFileName=" + this.realFileName + ", fileSize=" + this.fileSize + ", fileSha=" + this.fileSha + ", fileEnvelope=" + this.fileEnvelope + ", fileExt=" + this.fileExt + ", url=" + this.url + ", systemName=" + this.systemName + ", prefix=" + this.prefix + ", tenantId=" + this.tenantId + ", uploader=" + this.uploader + ", uploadTime=" + this.uploadTime + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Y9FileStore)) {
            return false;
        }
        Y9FileStore other = (Y9FileStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$fileSize = this.fileSize;
        Long other$fileSize = other.fileSize;
        if (this$fileSize == null ? other$fileSize != null : !((Object)this$fileSize).equals(other$fileSize)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        FileStoreTypeEnum this$storeType = this.storeType;
        FileStoreTypeEnum other$storeType = other.storeType;
        if (this$storeType == null ? other$storeType != null : !this$storeType.equals(other$storeType)) {
            return false;
        }
        String this$fullPath = this.fullPath;
        String other$fullPath = other.fullPath;
        if (this$fullPath == null ? other$fullPath != null : !this$fullPath.equals(other$fullPath)) {
            return false;
        }
        String this$fileName = this.fileName;
        String other$fileName = other.fileName;
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$realFileName = this.realFileName;
        String other$realFileName = other.realFileName;
        if (this$realFileName == null ? other$realFileName != null : !this$realFileName.equals(other$realFileName)) {
            return false;
        }
        String this$fileSha = this.fileSha;
        String other$fileSha = other.fileSha;
        if (this$fileSha == null ? other$fileSha != null : !this$fileSha.equals(other$fileSha)) {
            return false;
        }
        String this$fileEnvelope = this.fileEnvelope;
        String other$fileEnvelope = other.fileEnvelope;
        if (this$fileEnvelope == null ? other$fileEnvelope != null : !this$fileEnvelope.equals(other$fileEnvelope)) {
            return false;
        }
        String this$fileExt = this.fileExt;
        String other$fileExt = other.fileExt;
        if (this$fileExt == null ? other$fileExt != null : !this$fileExt.equals(other$fileExt)) {
            return false;
        }
        String this$url = this.url;
        String other$url = other.url;
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$systemName = this.systemName;
        String other$systemName = other.systemName;
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        String this$prefix = this.prefix;
        String other$prefix = other.prefix;
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$tenantId = this.tenantId;
        String other$tenantId = other.tenantId;
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$uploader = this.uploader;
        String other$uploader = other.uploader;
        if (this$uploader == null ? other$uploader != null : !this$uploader.equals(other$uploader)) {
            return false;
        }
        Date this$uploadTime = this.uploadTime;
        Date other$uploadTime = other.uploadTime;
        return !(this$uploadTime == null ? other$uploadTime != null : !((Object)this$uploadTime).equals(other$uploadTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Y9FileStore;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $fileSize = this.fileSize;
        result = result * 59 + ($fileSize == null ? 43 : ((Object)$fileSize).hashCode());
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        FileStoreTypeEnum $storeType = this.storeType;
        result = result * 59 + ($storeType == null ? 43 : $storeType.hashCode());
        String $fullPath = this.fullPath;
        result = result * 59 + ($fullPath == null ? 43 : $fullPath.hashCode());
        String $fileName = this.fileName;
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $realFileName = this.realFileName;
        result = result * 59 + ($realFileName == null ? 43 : $realFileName.hashCode());
        String $fileSha = this.fileSha;
        result = result * 59 + ($fileSha == null ? 43 : $fileSha.hashCode());
        String $fileEnvelope = this.fileEnvelope;
        result = result * 59 + ($fileEnvelope == null ? 43 : $fileEnvelope.hashCode());
        String $fileExt = this.fileExt;
        result = result * 59 + ($fileExt == null ? 43 : $fileExt.hashCode());
        String $url = this.url;
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $systemName = this.systemName;
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        String $prefix = this.prefix;
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $tenantId = this.tenantId;
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $uploader = this.uploader;
        result = result * 59 + ($uploader == null ? 43 : $uploader.hashCode());
        Date $uploadTime = this.uploadTime;
        result = result * 59 + ($uploadTime == null ? 43 : ((Object)$uploadTime).hashCode());
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public FileStoreTypeEnum getStoreType() {
        return this.storeType;
    }

    @Generated
    public String getFullPath() {
        return this.fullPath;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getRealFileName() {
        return this.realFileName;
    }

    @Generated
    public Long getFileSize() {
        return this.fileSize;
    }

    @Generated
    public String getFileSha() {
        return this.fileSha;
    }

    @Generated
    public String getFileEnvelope() {
        return this.fileEnvelope;
    }

    @Generated
    public String getFileExt() {
        return this.fileExt;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getUploader() {
        return this.uploader;
    }

    @Generated
    public Date getUploadTime() {
        return this.uploadTime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setStoreType(FileStoreTypeEnum storeType) {
        this.storeType = storeType;
    }

    @Generated
    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setRealFileName(String realFileName) {
        this.realFileName = realFileName;
    }

    @Generated
    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    @Generated
    public void setFileSha(String fileSha) {
        this.fileSha = fileSha;
    }

    @Generated
    public void setFileEnvelope(String fileEnvelope) {
        this.fileEnvelope = fileEnvelope;
    }

    @Generated
    public void setFileExt(String fileExt) {
        this.fileExt = fileExt;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setUploader(String uploader) {
        this.uploader = uploader;
    }

    @Generated
    public void setUploadTime(Date uploadTime) {
        this.uploadTime = uploadTime;
    }
}

