/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.DataApiOnlineService;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9public.entity.DataApiOnlineEntity;
import net.risesoft.y9public.entity.DataApiOnlineInfoEntity;
import net.risesoft.y9public.repository.DataApiOnlineInfoRepository;
import net.risesoft.y9public.repository.DataApiOnlineRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="dataApiOnlineService")
public class DataApiOnlineServiceImpl
implements DataApiOnlineService {
    private final DataApiOnlineRepository dataApiOnlineRepository;
    private final DataApiOnlineInfoRepository dataApiOnlineInfoRepository;

    @Override
    @Transactional(readOnly=false)
    public Y9Result<List<String>> deleteData(String id) {
        ArrayList<String> removeIds = new ArrayList<String>();
        try {
            DataApiOnlineEntity dataApiOnlineEntity = this.dataApiOnlineRepository.findById(id).orElse(null);
            if (dataApiOnlineEntity == null) {
                return Y9Result.failure((String)"\u5220\u9664\u5931\u8d25\uff0c\u4e3b\u4f53\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if (dataApiOnlineEntity.getType().equals("folder")) {
                this.delete(id, removeIds);
            } else {
                this.dataApiOnlineInfoRepository.deleteById(id);
            }
            this.dataApiOnlineRepository.deleteById(id);
            removeIds.add(id);
        }
        catch (Exception e) {
            return Y9Result.failure((String)("\u5220\u9664\u5931\u8d25\uff0c" + e.getMessage()));
        }
        return Y9Result.success(removeIds);
    }

    private void delete(String parentId, List<String> removeIds) {
        List<String> ids = this.dataApiOnlineRepository.findByParentId(parentId);
        for (String id : ids) {
            DataApiOnlineEntity dataApiOnlineEntity = this.dataApiOnlineRepository.findById(id).orElse(null);
            if (dataApiOnlineEntity.getType().equals("folder")) {
                this.delete(dataApiOnlineEntity.getId(), removeIds);
            } else {
                this.dataApiOnlineInfoRepository.deleteById(id);
            }
            this.dataApiOnlineRepository.deleteById(id);
            removeIds.add(id);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public Y9Result<DataApiOnlineEntity> saveData(DataApiOnlineEntity entity, DataApiOnlineInfoEntity infoEntity) {
        if (StringUtils.isBlank((CharSequence)entity.getId())) {
            entity.setId(Y9IdGenerator.genId());
        }
        if (infoEntity != null) {
            infoEntity.setId(entity.getId());
            this.dataApiOnlineInfoRepository.save((Object)infoEntity);
        }
        return Y9Result.success((Object)((Object)((DataApiOnlineEntity)((Object)this.dataApiOnlineRepository.save((Object)entity)))), (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public List<Map<String, Object>> getTree(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            id = "0";
        }
        return this.getListMap(id);
    }

    private List<Map<String, Object>> getListMap(String parentId) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        List<DataApiOnlineEntity> apiList = this.dataApiOnlineRepository.findByParentIdOrderByCreateTime(parentId);
        for (DataApiOnlineEntity apiOnlineEntity : apiList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", apiOnlineEntity.getId());
            map.put("name", apiOnlineEntity.getName());
            map.put("parentId", apiOnlineEntity.getParentId());
            map.put("type", apiOnlineEntity.getType());
            if (apiOnlineEntity.getType().equals("folder")) {
                map.put("children", this.getListMap(apiOnlineEntity.getId()));
            } else {
                String json = ((DataApiOnlineInfoEntity)this.dataApiOnlineInfoRepository.findById(apiOnlineEntity.getId()).orElse(null)).getFormData();
                map.put("ApiForm", Y9JsonUtil.readHashMap((String)json));
            }
            listMap.add(map);
        }
        return listMap;
    }

    @Generated
    public DataApiOnlineServiceImpl(DataApiOnlineRepository dataApiOnlineRepository, DataApiOnlineInfoRepository dataApiOnlineInfoRepository) {
        this.dataApiOnlineRepository = dataApiOnlineRepository;
        this.dataApiOnlineInfoRepository = dataApiOnlineInfoRepository;
    }
}

