/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.DataApiOnlineService;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9public.entity.DataApiOnlineEntity;
import net.risesoft.y9public.entity.DataApiOnlineInfoEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/rest/apionline"}, produces={"application/json"})
public class ApiOnlineController {
    private final DataApiOnlineService dataApiOnlineService;

    @PostMapping(value={"/saveData"})
    public Y9Result<DataApiOnlineEntity> saveData(@RequestBody String json) {
        HashMap map = Y9JsonUtil.readHashMap((String)json);
        DataApiOnlineEntity entity = new DataApiOnlineEntity();
        entity.setId((String)map.get("id"));
        entity.setName((String)map.get("name"));
        entity.setParentId((String)map.get("parentId"));
        entity.setType((String)map.get("type"));
        if (map.get("type").equals("folder")) {
            return this.dataApiOnlineService.saveData(entity, null);
        }
        DataApiOnlineInfoEntity infoEntity = new DataApiOnlineInfoEntity();
        infoEntity.setId(entity.getId());
        infoEntity.setFormData(Y9JsonUtil.writeValueAsString(map.get("ApiForm")));
        return this.dataApiOnlineService.saveData(entity, infoEntity);
    }

    @PostMapping(value={"/deleteData"})
    public Y9Result<List<String>> deleteData(@RequestParam String id) {
        return this.dataApiOnlineService.deleteData(id);
    }

    @GetMapping(value={"/getTree"})
    public Y9Result<List<Map<String, Object>>> getTree(String id) {
        return Y9Result.success(this.dataApiOnlineService.getTree(id));
    }

    @Generated
    public ApiOnlineController(DataApiOnlineService dataApiOnlineService) {
        this.dataApiOnlineService = dataApiOnlineService;
    }
}

