/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.web.handler;

import java.util.List;
import javax.validation.ConstraintViolationException;
import lombok.Generated;
import net.risesoft.exception.ErrorCode;
import net.risesoft.exception.GlobalErrorCodeEnum;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.exception.Y9BusinessException;
import net.risesoft.y9.exception.Y9PermissionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ControllerAdvice(basePackages={"net.risesoft"})
public class Y9ControllerAdvice {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9ControllerAdvice.class);

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Y9Result<Object> processException(ConstraintViolationException e) {
        LOGGER.warn(e.getMessage(), (Throwable)e);
        return Y9Result.failure((ErrorCode)GlobalErrorCodeEnum.INVALID_ARGUMENT, (String)(StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : GlobalErrorCodeEnum.INVALID_ARGUMENT.getDescription()));
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Y9Result<Object> processException(MissingServletRequestParameterException e) {
        LOGGER.warn(e.getMessage(), (Throwable)e);
        return Y9Result.failure((ErrorCode)GlobalErrorCodeEnum.INVALID_ARGUMENT, (String)(StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : GlobalErrorCodeEnum.INVALID_ARGUMENT.getDescription()));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Y9Result<Object> processException(MethodArgumentTypeMismatchException e) {
        LOGGER.warn(e.getMessage(), (Throwable)e);
        String message = String.format("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff0c\u9519\u8bef\u53c2\u6570[%s]\u503c\u4e3a[%s]\uff0c\u8bf7\u68c0\u67e5\u5176\u7c7b\u578b\u6216\u8f93\u5165\u9650\u5236", e.getParameter().getParameterName(), e.getValue());
        return Y9Result.failure((ErrorCode)GlobalErrorCodeEnum.INVALID_ARGUMENT, (String)message);
    }

    @ExceptionHandler(value={MissingPathVariableException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Y9Result<Object> processException(MissingPathVariableException e) {
        LOGGER.warn(e.getMessage(), (Throwable)e);
        return Y9Result.failure((ErrorCode)GlobalErrorCodeEnum.INVALID_ARGUMENT, (String)(StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : GlobalErrorCodeEnum.INVALID_ARGUMENT.getDescription()));
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Y9Result<Object> processException(BindException e) {
        LOGGER.warn(e.getMessage(), (Throwable)e);
        FieldError fieldError = e.getBindingResult().getFieldError();
        if (fieldError != null && StringUtils.isNotBlank((CharSequence)fieldError.getDefaultMessage())) {
            return Y9Result.failure((ErrorCode)GlobalErrorCodeEnum.INVALID_ARGUMENT, (String)(fieldError.getField() + fieldError.getDefaultMessage()));
        }
        StringBuilder msg = new StringBuilder();
        List fieldErrors = e.getFieldErrors();
        fieldErrors.forEach(oe -> msg.append(oe.getObjectName()).append(".").append(oe.getField()).append("=").append(oe.getRejectedValue()).append("\uff0c\u4e0e\u9884\u671f\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d"));
        return Y9Result.failure((ErrorCode)GlobalErrorCodeEnum.INVALID_ARGUMENT, (String)msg.toString());
    }

    @ExceptionHandler(value={Y9BusinessException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Y9Result<Object> processException(Y9BusinessException e) {
        LOGGER.warn(e.getMessage(), (Throwable)e);
        return Y9Result.failure((int)e.getCode(), (String)(StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : GlobalErrorCodeEnum.FAILURE.getDescription()));
    }

    @ExceptionHandler(value={Y9PermissionException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public Y9Result<Object> processException(Y9PermissionException e) {
        LOGGER.warn(e.getMessage(), (Throwable)e);
        return Y9Result.failure((int)e.getCode(), (String)(StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : GlobalErrorCodeEnum.PERMISSION_DENIED.getDescription()));
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Y9Result<Object> processException(Throwable e) {
        LOGGER.warn(e.getMessage(), e);
        return Y9Result.failure((String)GlobalErrorCodeEnum.FAILURE.getDescription());
    }
}

