/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.web;

import net.risesoft.enums.ValuedEnum;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.lang.Nullable;

public class Y9LaxStringToEnumConverterFactory
implements ConverterFactory<String, Enum> {
    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToEnum<T>(targetType);
    }

    private static class StringToEnum<T extends Enum>
    implements Converter<String, T> {
        private final Class<T> enumType;

        StringToEnum(Class<T> enumType) {
            this.enumType = enumType;
        }

        @Nullable
        public T convert(String source) {
            if (source.isEmpty()) {
                return null;
            }
            for (Enum enumConstant : (Enum[])this.enumType.getEnumConstants()) {
                if (StringUtils.equalsIgnoreCase((CharSequence)enumConstant.toString(), (CharSequence)source)) {
                    return (T)enumConstant;
                }
                if (!(enumConstant instanceof ValuedEnum) || !StringUtils.equalsIgnoreCase((CharSequence)((ValuedEnum)enumConstant).getValue().toString(), (CharSequence)source)) continue;
                return (T)enumConstant;
            }
            throw new IllegalArgumentException("No enum constant " + this.enumType.getCanonicalName() + "." + source);
        }
    }
}

