/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.permission.aop.advice;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.risesoft.enums.platform.ManagerLevelEnum;
import net.risesoft.exception.ErrorCode;
import net.risesoft.exception.GlobalErrorCodeEnum;
import net.risesoft.permission.annotation.IsManager;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.exception.util.Y9ExceptionUtil;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.core.annotation.AnnotationUtils;

public class IsManagerAdvice
implements MethodBeforeAdvice {
    public void before(Method method, Object[] args, Object target) throws Throwable {
        IsManager isManager = (IsManager)AnnotationUtils.findAnnotation((Method)method, IsManager.class);
        if (isManager != null) {
            this.checkAnyManager(isManager.value(), isManager.globalOnly());
            return;
        }
        isManager = (IsManager)AnnotationUtils.findAnnotation(method.getDeclaringClass(), IsManager.class);
        if (isManager != null) {
            this.checkAnyManager(isManager.value(), isManager.globalOnly());
            return;
        }
    }

    private void checkAnyManager(ManagerLevelEnum[] managerLevelEnums, boolean globalOnly) {
        if (managerLevelEnums != null) {
            for (ManagerLevelEnum managerLevelEnum : managerLevelEnums) {
                if (!managerLevelEnum.equals((Object)Y9LoginUserHolder.getUserInfo().getManagerLevel()) || !Y9LoginUserHolder.getUserInfo().isGlobalManager() && Y9LoginUserHolder.getUserInfo().isGlobalManager() != globalOnly) continue;
                return;
            }
            String managerNames = Arrays.stream(managerLevelEnums).map(ManagerLevelEnum::getName).collect(Collectors.joining(","));
            throw Y9ExceptionUtil.permissionException((ErrorCode)GlobalErrorCodeEnum.NOT_MANAGER, (Object[])new Object[]{managerNames});
        }
    }
}

