/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.permission.aop.advice;

import java.lang.reflect.Method;
import java.util.Arrays;
import net.risesoft.api.platform.permission.PersonRoleApi;
import net.risesoft.api.platform.permission.PositionRoleApi;
import net.risesoft.enums.LogicalEnum;
import net.risesoft.enums.platform.IdentityEnum;
import net.risesoft.exception.ErrorCode;
import net.risesoft.exception.GlobalErrorCodeEnum;
import net.risesoft.permission.annotation.HasRoles;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.exception.util.Y9ExceptionUtil;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.core.annotation.AnnotationUtils;

public class HasRolesAdvice
implements MethodBeforeAdvice {
    private final PersonRoleApi personRoleApi;
    private final PositionRoleApi positionRoleApi;

    public HasRolesAdvice(PersonRoleApi personRoleApi, PositionRoleApi positionRoleApi) {
        this.personRoleApi = personRoleApi;
        this.positionRoleApi = positionRoleApi;
    }

    public void before(Method method, Object[] args, Object target) throws Throwable {
        HasRoles hasRoles = (HasRoles)AnnotationUtils.findAnnotation((Method)method, HasRoles.class);
        if (hasRoles != null && hasRoles.value() != null) {
            String[] customIds = hasRoles.value();
            LogicalEnum logical = hasRoles.logical();
            IdentityEnum identity = hasRoles.identity();
            if (IdentityEnum.PERSON.equals((Object)identity) && LogicalEnum.AND.equals((Object)logical)) {
                this.checkAllPersonRoles(customIds);
                return;
            }
            if (IdentityEnum.PERSON.equals((Object)identity) && LogicalEnum.OR.equals((Object)logical)) {
                this.checkAnyPersonRoles(customIds);
                return;
            }
            if (IdentityEnum.POSITION.equals((Object)identity) && LogicalEnum.AND.equals((Object)logical)) {
                this.checkAllPositionRoles(customIds);
                return;
            }
            if (IdentityEnum.POSITION.equals((Object)identity) && LogicalEnum.OR.equals((Object)logical)) {
                this.checkAnyPositionRoles(customIds);
                return;
            }
        }
    }

    private void checkAnyPositionRoles(String[] customIds) {
        for (String customId : customIds) {
            if (!this.hasPositionRole(customId)) continue;
            return;
        }
        throw Y9ExceptionUtil.permissionException((ErrorCode)GlobalErrorCodeEnum.POSITION_NOT_HAS_ROLE, (Object[])new Object[]{Arrays.toString(customIds)});
    }

    private boolean hasPositionRole(String customId) {
        return (Boolean)this.positionRoleApi.hasRoleByCustomId(Y9LoginUserHolder.getTenantId(), Y9LoginUserHolder.getPositionId(), customId).getData();
    }

    private void checkAllPositionRoles(String[] customIds) {
        for (String customId : customIds) {
            if (this.hasPositionRole(customId)) continue;
            throw Y9ExceptionUtil.permissionException((ErrorCode)GlobalErrorCodeEnum.POSITION_NOT_HAS_ROLE, (Object[])new Object[]{customId});
        }
    }

    private void checkAnyPersonRoles(String[] customIds) {
        for (String customId : customIds) {
            if (!this.hasPersonRole(customId)) continue;
            return;
        }
        throw Y9ExceptionUtil.permissionException((ErrorCode)GlobalErrorCodeEnum.PERSON_NOT_HAS_ROLE, (Object[])new Object[]{Arrays.toString(customIds)});
    }

    private void checkAllPersonRoles(String[] customIds) {
        if (customIds != null && customIds.length > 0) {
            for (String customId : customIds) {
                if (this.hasPersonRole(customId)) continue;
                throw Y9ExceptionUtil.permissionException((ErrorCode)GlobalErrorCodeEnum.PERSON_NOT_HAS_ROLE, (Object[])new Object[]{customId});
            }
        }
    }

    private boolean hasPersonRole(String customId) {
        return (Boolean)this.personRoleApi.hasRoleByCustomId(Y9LoginUserHolder.getTenantId(), Y9LoginUserHolder.getPersonId(), customId).getData();
    }
}

