/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.permission.aop.advice;

import java.lang.reflect.Method;
import java.util.Arrays;
import net.risesoft.api.platform.permission.PersonResourceApi;
import net.risesoft.api.platform.permission.PositionResourceApi;
import net.risesoft.enums.LogicalEnum;
import net.risesoft.enums.platform.AuthorityEnum;
import net.risesoft.enums.platform.IdentityEnum;
import net.risesoft.exception.ErrorCode;
import net.risesoft.exception.GlobalErrorCodeEnum;
import net.risesoft.permission.annotation.HasAuthorities;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.exception.util.Y9ExceptionUtil;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.core.annotation.AnnotationUtils;

public class HasAuthoritiesAdvice
implements MethodBeforeAdvice {
    private final PersonResourceApi personResourceApi;
    private final PositionResourceApi positionResourceApi;

    public HasAuthoritiesAdvice(PersonResourceApi personResourceApi, PositionResourceApi positionResourceApi) {
        this.personResourceApi = personResourceApi;
        this.positionResourceApi = positionResourceApi;
    }

    public void before(Method method, Object[] args, Object target) throws Throwable {
        HasAuthorities hasAuthorities = (HasAuthorities)AnnotationUtils.findAnnotation((Method)method, HasAuthorities.class);
        if (hasAuthorities != null && hasAuthorities.value() != null) {
            String[] customIds = hasAuthorities.value();
            AuthorityEnum authority = hasAuthorities.authority();
            LogicalEnum logical = hasAuthorities.logical();
            IdentityEnum identity = hasAuthorities.identity();
            if (IdentityEnum.PERSON.equals((Object)identity) && LogicalEnum.AND.equals((Object)logical)) {
                this.checkAllPersonPermission(customIds, authority);
                return;
            }
            if (IdentityEnum.PERSON.equals((Object)identity) && LogicalEnum.OR.equals((Object)logical)) {
                this.checkAnyPersonPermission(customIds, authority);
                return;
            }
            if (IdentityEnum.POSITION.equals((Object)identity) && LogicalEnum.AND.equals((Object)logical)) {
                this.checkAllPositionPermission(customIds, authority);
                return;
            }
            if (IdentityEnum.POSITION.equals((Object)identity) && LogicalEnum.OR.equals((Object)logical)) {
                this.checkAnyPositionPermission(customIds, authority);
                return;
            }
        }
    }

    private void checkAllPersonPermission(String[] customIds, AuthorityEnum authority) {
        for (String customId : customIds) {
            if (this.hasPersonPermission(customId, authority)) continue;
            throw Y9ExceptionUtil.permissionException((ErrorCode)GlobalErrorCodeEnum.PERSON_UNAUTHORIZED_RESOURCE, (Object[])new Object[]{customId});
        }
    }

    private void checkAnyPersonPermission(String[] customIds, AuthorityEnum authority) {
        for (String customId : customIds) {
            if (!this.hasPersonPermission(customId, authority)) continue;
            return;
        }
        throw Y9ExceptionUtil.permissionException((ErrorCode)GlobalErrorCodeEnum.PERSON_UNAUTHORIZED_RESOURCE, (Object[])new Object[]{Arrays.toString(customIds)});
    }

    private void checkAllPositionPermission(String[] customIds, AuthorityEnum authority) {
        for (String customId : customIds) {
            if (this.hasPersonPermission(customId, authority)) continue;
            throw Y9ExceptionUtil.permissionException((ErrorCode)GlobalErrorCodeEnum.POSITION_UNAUTHORIZED_RESOURCE, (Object[])new Object[]{customId});
        }
    }

    private void checkAnyPositionPermission(String[] customIds, AuthorityEnum authority) {
        for (String customId : customIds) {
            if (!this.hasPositionPermission(customId, authority)) continue;
            return;
        }
        throw Y9ExceptionUtil.permissionException((ErrorCode)GlobalErrorCodeEnum.POSITION_UNAUTHORIZED_RESOURCE, (Object[])new Object[]{Arrays.toString(customIds)});
    }

    private boolean hasPersonPermission(String customId, AuthorityEnum authority) {
        return (Boolean)this.personResourceApi.hasPermissionByCustomId(Y9LoginUserHolder.getTenantId(), Y9LoginUserHolder.getPersonId(), customId, authority).getData();
    }

    private boolean hasPositionPermission(String customId, AuthorityEnum authority) {
        return (Boolean)this.positionResourceApi.hasPermissionByCustomId(Y9LoginUserHolder.getTenantId(), Y9LoginUserHolder.getPositionId(), customId, authority).getData();
    }
}

