/*
 * Decompiled with CFR 0.152.
 */
package y9.autoconfiguration.listener.kafka;

import java.util.Objects;
import lombok.Generated;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.json.Y9JsonUtil;
import net.risesoft.y9.pubsub.event.Y9EventOrg;
import net.risesoft.y9.pubsub.message.Y9MessageOrg;
import net.risesoft.y9.pubsub.message.Y9MessageOrgReply;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={KafkaAutoConfiguration.class})
@ConditionalOnProperty(name={"y9.feature.listener.kafka.enabled"}, havingValue="true", matchIfMissing=true)
public class Y9ListenerKafkaConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Y9ListenerKafkaConfiguration.class);
    private KafkaTemplate<Object, Object> y9KafkaTemplate;

    @KafkaListener(topics={"y9_org_event"})
    public void messageOrgListener4kafka(ConsumerRecord<String, String> data) {
        String value = ((String)data.value()).toString();
        Y9MessageOrg msg = null;
        try {
            msg = (Y9MessageOrg)Y9JsonUtil.readValue((String)value, Y9MessageOrg.class);
            Y9MessageOrgReply msgReply = new Y9MessageOrgReply();
            msgReply.setClientIp(Y9Context.getHostIp());
            msgReply.setSystemName(Y9Context.getSystemName());
            msgReply.setEventType(msg.getEventType());
            msgReply.setTenantId(msg.getTenantId());
            String json = Y9JsonUtil.writeValueAsString((Object)msgReply);
            if (this.y9KafkaTemplate == null) {
                this.y9KafkaTemplate = (KafkaTemplate)Y9Context.getBean((String)"y9KafkaTemplate");
            }
            if (this.y9KafkaTemplate != null) {
                this.y9KafkaTemplate.send("y9_org_event_reply", (Object)json);
                LOGGER.info("\u5411\u6d88\u606f\u4e2d\u95f4\u4ef6\u53d1\u9001\u56de\u6267\u3002");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if ("ALL".equals(msg.getEventTarget()) || Objects.equals(Y9Context.getSystemName(), msg.getEventTarget())) {
            try {
                Y9EventOrg event = new Y9EventOrg();
                event.setEventType(msg.getEventType());
                event.setOrgObj((Object)msg.getOrgObj());
                event.setTenantId(msg.getTenantId());
                Y9Context.publishEvent((ApplicationEvent)event);
                LOGGER.info("[org]\u5c06\u6d88\u606f\u4e2d\u95f4\u4ef6\u53d1\u8fc7\u6765\u7684\u6d88\u606f\u8f6c\u6362\u6210spring\u7684\u4e8b\u4ef6\u540e\u53d1\u9001\uff1a" + event.toString());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={Y9Context.class})
    public Y9Context y9Context() {
        return new Y9Context();
    }

    @Bean(value={"y9KafkaTemplate"})
    @ConditionalOnMissingBean(name={"y9KafkaTemplate"})
    public KafkaTemplate<?, ?> y9KafkaTemplate(ProducerFactory<Object, Object> kafkaProducerFactory) {
        return new KafkaTemplate(kafkaProducerFactory);
    }
}

