/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.liquibase;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.Map;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import lombok.Generated;
import net.risesoft.liquibase.LiquibaseUtil;
import net.risesoft.y9.configuration.feature.liquibase.Y9LiquibaseProperties;
import net.risesoft.y9.tenant.datasource.Y9TenantDataSourceLookup;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ResourceLoader;

public class Y9MultiTenantSpringLiquibase
implements InitializingBean {
    private final Y9TenantDataSourceLookup y9TenantDataSourceLookup;
    private final Y9LiquibaseProperties properties;
    private final ResourceLoader resourceLoader;

    public void afterPropertiesSet() throws Exception {
        this.updateAll();
    }

    public void updateAll() throws LiquibaseException {
        Map dataSources = this.y9TenantDataSourceLookup.getDataSources();
        for (Map.Entry stringDruidDataSourceEntry : dataSources.entrySet()) {
            DruidDataSource dataSource = (DruidDataSource)stringDruidDataSourceEntry.getValue();
            this.update(dataSource);
        }
    }

    private void update(DruidDataSource dataSource) throws LiquibaseException {
        SpringLiquibase liquibase = LiquibaseUtil.getSpringLiquibase(dataSource, this.properties, this.resourceLoader, true);
        liquibase.afterPropertiesSet();
    }

    public void update(String tenantId) throws LiquibaseException {
        DruidDataSource dataSource = (DruidDataSource)this.y9TenantDataSourceLookup.getDataSource(tenantId);
        this.update(dataSource);
    }

    @Generated
    public Y9MultiTenantSpringLiquibase(Y9TenantDataSourceLookup y9TenantDataSourceLookup, Y9LiquibaseProperties properties, ResourceLoader resourceLoader) {
        this.y9TenantDataSourceLookup = y9TenantDataSourceLookup;
        this.properties = properties;
        this.resourceLoader = resourceLoader;
    }
}

