/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.liquibase;

import com.alibaba.druid.pool.DruidDataSource;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import net.risesoft.y9.configuration.feature.liquibase.Y9LiquibaseProperties;
import org.springframework.boot.autoconfigure.liquibase.DataSourceClosingSpringLiquibase;
import org.springframework.core.io.ResourceLoader;

public class LiquibaseUtil {
    public static SpringLiquibase getSpringLiquibase(DruidDataSource dataSource, Y9LiquibaseProperties properties, ResourceLoader resourceLoader, boolean isTenant) {
        DataSource migrateDataSource = LiquibaseUtil.getMigrateDataSource(dataSource);
        SpringLiquibase liquibase = dataSource == migrateDataSource ? new SpringLiquibase() : new DataSourceClosingSpringLiquibase();
        liquibase.setDataSource(migrateDataSource);
        liquibase.setResourceLoader(resourceLoader);
        liquibase.setChangeLog(isTenant ? properties.getTenantChangeLog() : properties.getPublicChangeLog());
        liquibase.setClearCheckSums(properties.isClearChecksums());
        liquibase.setContexts(properties.getContexts());
        liquibase.setLiquibaseTablespace(properties.getLiquibaseTablespace());
        liquibase.setDatabaseChangeLogTable(properties.getDatabaseChangeLogTable());
        liquibase.setDatabaseChangeLogLockTable(properties.getDatabaseChangeLogLockTable());
        liquibase.setDropFirst(properties.isDropFirst());
        liquibase.setShouldRun(isTenant ? properties.isTenantEnabled() : properties.isPublicEnabled());
        liquibase.setLabels(properties.getLabels());
        liquibase.setChangeLogParameters(properties.getParameters());
        liquibase.setRollbackFile(properties.getRollbackFile());
        liquibase.setTestRollbackOnUpdate(properties.isTestRollbackOnUpdate());
        liquibase.setTag(properties.getTag());
        return liquibase;
    }

    public static DataSource getMigrateDataSource(DruidDataSource dataSource) {
        return dataSource;
    }
}

