/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.Scope;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.logging.Logger;

public class KingbaseDatabase
extends PostgresDatabase {
    public static final String PRODUCT_NAME = "KingbaseES";
    private static final Logger LOG = Scope.getCurrentScope().getLog(KingbaseDatabase.class);

    public String getShortName() {
        return "kingbase";
    }

    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public Integer getDefaultPort() {
        return 54321;
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:kingbase8")) {
            return "com.kingbase8.Driver";
        }
        return null;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        if (!PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName())) {
            return false;
        }
        int majorVersion = conn.getDatabaseMajorVersion();
        int minorVersion = conn.getDatabaseMinorVersion();
        if (majorVersion < 9 || majorVersion == 9 && minorVersion < 2) {
            LOG.warning(String.format("Your PostgreSQL software version (%d.%d) seems to indicate that your software is older than %d.%d. This means that you might encounter strange behaviour and incorrect error messages.", majorVersion, minorVersion, 9, 2));
            return true;
        }
        return true;
    }
}

