/*
 * Decompiled with CFR 0.152.
 */
package y9.autoconfiguration.tenant;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import java.sql.SQLException;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.tenant.datasource.Y9TenantDataSource;
import net.risesoft.y9.tenant.datasource.Y9TenantDataSourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.StringUtils;
import y9.jpa.extension.Y9EnableJpaRepositories;

@Configuration
@AutoConfigureBefore(value={DruidDataSourceAutoConfigure.class})
@EnableConfigurationProperties(value={JpaProperties.class})
@EnableTransactionManagement(proxyTargetClass=true, mode=AdviceMode.ASPECTJ)
@Y9EnableJpaRepositories(basePackages={"${y9.feature.jpa.packagesToScanRepositoryTenant}"}, includeFilters={@ComponentScan.Filter(classes={JpaRepository.class}, type=FilterType.ASSIGNABLE_TYPE)}, entityManagerFactoryRef="rsTenantEntityManagerFactory", transactionManagerRef="rsTenantTransactionManager")
public class SpringMultiTenantConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringMultiTenantConfiguration.class);

    @Bean(value={"defaultDataSource"})
    @ConditionalOnMissingBean(name={"defaultDataSource"})
    public DruidDataSource defaultDataSource(Environment environment) {
        DruidDataSource dataSource = DruidDataSourceBuilder.create().build();
        String tenantDefault = (String)environment.getProperty("spring.datasource.druid.tenantDefault", String.class);
        if (!StringUtils.hasText((String)tenantDefault)) {
            tenantDefault = "spring.datasource.druid.y9-public";
        }
        String prefix = tenantDefault + ".";
        String jdbcUrl = (String)environment.getProperty(prefix + "url", String.class);
        String username = (String)environment.getProperty(prefix + "username", String.class);
        String password = (String)environment.getProperty(prefix + "password", String.class);
        Boolean testWhileIdle = (Boolean)environment.getProperty(prefix + "testWhileIdle", Boolean.class);
        Boolean testOnBorrow = (Boolean)environment.getProperty(prefix + "testOnBorrow", Boolean.class);
        Boolean testOnReturn = (Boolean)environment.getProperty(prefix + "testOnReturn", Boolean.class);
        String validationQuery = (String)environment.getProperty(prefix + "validationQuery", String.class);
        Boolean useGlobalDataSourceStat = (Boolean)environment.getProperty(prefix + "useGlobalDataSourceStat", Boolean.class);
        String filters = (String)environment.getProperty(prefix + "filters", String.class);
        Boolean clearFiltersEnable = (Boolean)environment.getProperty(prefix + "clearFiltersEnable", Boolean.class);
        Boolean resetStatEnable = (Boolean)environment.getProperty(prefix + "resetStatEnable", Boolean.class);
        Integer notFullTimeoutRetryCount = (Integer)environment.getProperty(prefix + "notFullTimeoutRetryCount", Integer.class);
        Long timeBetweenEvictionRunsMillis = (Long)environment.getProperty(prefix + "timeBetweenEvictionRunsMillis", Long.class);
        Integer maxWaithThreadCount = (Integer)environment.getProperty(prefix + "maxWaithThreadCount", Integer.class);
        Long maxWaitMillis = (Long)environment.getProperty(prefix + "maxWaitMillis", Long.class);
        Boolean failFast = (Boolean)environment.getProperty(prefix + "failFast", Boolean.class);
        Long phyTimeoutMillis = (Long)environment.getProperty(prefix + "phyTimeoutMillis", Long.class);
        Long phyMaxUseCount = (Long)environment.getProperty(prefix + "phyMaxUseCount", Long.class);
        Long minEvictableIdleTimeMillis = (Long)environment.getProperty(prefix + "minEvictableIdleTimeMillis", Long.class);
        Long maxEvictableIdleTimeMillis = (Long)environment.getProperty(prefix + "maxEvictableIdleTimeMillis", Long.class);
        Boolean keepAlive = (Boolean)environment.getProperty(prefix + "keepAlive", Boolean.class);
        Long keepAliveBetweenTimeMillis = (Long)environment.getProperty(prefix + "keepAliveBetweenTimeMillis", Long.class);
        Boolean poolPreparedStatements = (Boolean)environment.getProperty(prefix + "poolPreparedStatements", Boolean.class);
        Boolean initVariants = (Boolean)environment.getProperty(prefix + "initVariants", Boolean.class);
        Boolean initGlobalVariants = (Boolean)environment.getProperty(prefix + "initGlobalVariants", Boolean.class);
        Boolean useUnfairLock = (Boolean)environment.getProperty(prefix + "useUnfairLock", Boolean.class);
        String driverClassName = (String)environment.getProperty(prefix + "driverClassName", String.class);
        Integer initialSize = (Integer)environment.getProperty(prefix + "initialSize", Integer.class);
        Integer minIdle = (Integer)environment.getProperty(prefix + "minIdle", Integer.class);
        Integer maxActive = (Integer)environment.getProperty(prefix + "maxActive", Integer.class);
        Boolean killWhenSocketReadTimeout = (Boolean)environment.getProperty(prefix + "killWhenSocketReadTimeout", Boolean.class);
        String connectionProperties = (String)environment.getProperty(prefix + "connectionProperties", String.class);
        Integer maxPoolPreparedStatementPerConnectionSize = (Integer)environment.getProperty(prefix + "maxPoolPreparedStatementPerConnectionSize", Integer.class);
        String initConnectionSqls = (String)environment.getProperty(prefix + "initConnectionSqls", String.class);
        if (jdbcUrl != null) {
            dataSource.setUrl(jdbcUrl);
        }
        if (username != null) {
            dataSource.setUsername(username);
        }
        if (password != null) {
            dataSource.setPassword(password);
        }
        if (testWhileIdle != null) {
            dataSource.setTestWhileIdle(testWhileIdle.booleanValue());
        }
        if (testOnBorrow != null) {
            dataSource.setTestOnBorrow(testOnBorrow.booleanValue());
        }
        if (testOnReturn != null) {
            dataSource.setTestOnReturn(testOnReturn.booleanValue());
        }
        if (validationQuery != null) {
            dataSource.setValidationQuery(validationQuery);
        }
        if (useGlobalDataSourceStat != null) {
            dataSource.setUseGlobalDataSourceStat(useGlobalDataSourceStat.booleanValue());
        }
        if (filters != null) {
            try {
                dataSource.setFilters(filters);
            }
            catch (SQLException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (clearFiltersEnable != null) {
            dataSource.setClearFiltersEnable(clearFiltersEnable.booleanValue());
        }
        if (resetStatEnable != null) {
            dataSource.setResetStatEnable(resetStatEnable.booleanValue());
        }
        if (notFullTimeoutRetryCount != null) {
            dataSource.setNotFullTimeoutRetryCount(notFullTimeoutRetryCount.intValue());
        }
        if (timeBetweenEvictionRunsMillis != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue());
        }
        if (maxWaithThreadCount != null) {
            dataSource.setMaxWaitThreadCount(maxWaithThreadCount.intValue());
        }
        if (maxWaitMillis != null) {
            dataSource.setMaxWait(maxWaitMillis.longValue());
        }
        if (failFast != null) {
            dataSource.setFailFast(failFast.booleanValue());
        }
        if (phyTimeoutMillis != null) {
            dataSource.setPhyTimeoutMillis(phyTimeoutMillis.longValue());
        }
        if (phyMaxUseCount != null) {
            dataSource.setPhyMaxUseCount(phyMaxUseCount.longValue());
        }
        if (minEvictableIdleTimeMillis != null) {
            dataSource.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue());
        }
        if (maxEvictableIdleTimeMillis != null) {
            dataSource.setMaxEvictableIdleTimeMillis(maxEvictableIdleTimeMillis.longValue());
        }
        if (keepAlive != null) {
            dataSource.setKeepAlive(keepAlive.booleanValue());
        }
        if (keepAliveBetweenTimeMillis != null) {
            dataSource.setKeepAliveBetweenTimeMillis(keepAliveBetweenTimeMillis.longValue());
        }
        if (poolPreparedStatements != null) {
            dataSource.setPoolPreparedStatements(poolPreparedStatements.booleanValue());
        }
        if (initVariants != null) {
            dataSource.setInitVariants(initVariants.booleanValue());
        }
        if (initGlobalVariants != null) {
            dataSource.setInitGlobalVariants(initGlobalVariants.booleanValue());
        }
        if (useUnfairLock != null) {
            dataSource.setUseUnfairLock(useUnfairLock.booleanValue());
        }
        if (driverClassName != null) {
            dataSource.setDriverClassName(driverClassName);
        }
        if (initialSize != null) {
            dataSource.setInitialSize(initialSize.intValue());
        }
        if (minIdle != null) {
            dataSource.setMinIdle(minIdle.intValue());
        }
        if (maxActive != null) {
            dataSource.setMaxActive(maxActive.intValue());
        }
        if (killWhenSocketReadTimeout != null) {
            dataSource.setKillWhenSocketReadTimeout(killWhenSocketReadTimeout.booleanValue());
        }
        if (connectionProperties != null) {
            dataSource.setConnectionProperties(connectionProperties);
        }
        if (maxPoolPreparedStatementPerConnectionSize != null) {
            dataSource.setMaxPoolPreparedStatementPerConnectionSize(maxPoolPreparedStatementPerConnectionSize.intValue());
        }
        if (initConnectionSqls != null) {
            StringTokenizer tokenizer = new StringTokenizer(initConnectionSqls, ";");
            dataSource.setConnectionInitSqls(Collections.list(tokenizer));
        }
        return dataSource;
    }

    @Bean(value={"jdbcTemplate4Tenant"})
    @ConditionalOnMissingBean(name={"jdbcTemplate4Tenant"})
    public JdbcTemplate jdbcTemplate4Tenant(@Qualifier(value="y9TenantDataSource") DataSource ds) {
        return new JdbcTemplate(ds);
    }

    @Bean
    @ConditionalOnMissingBean
    public JpaVendorAdapter jpaVendorAdapter() {
        return new HibernateJpaVendorAdapter();
    }

    @Primary
    @Bean(value={"rsTenantEntityManagerFactory", "entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean rsTenantEntityManagerFactory(@Qualifier(value="y9TenantDataSource") DataSource ds, JpaProperties jpaProperties, Environment environment) {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setPersistenceUnitName("y9Tenant");
        em.setDataSource(ds);
        em.setJpaVendorAdapter(this.jpaVendorAdapter());
        String basePackages = environment.getProperty("y9.feature.jpa.packagesToScanEntityTenant");
        em.setPackagesToScan(basePackages.split(","));
        em.setJpaPropertyMap(jpaProperties.getProperties());
        return em;
    }

    @Primary
    @Bean(value={"rsTenantTransactionManager", "transactionManager"})
    public PlatformTransactionManager rsTenantTransactionManager(@Qualifier(value="rsTenantEntityManagerFactory") EntityManagerFactory emf) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(emf);
        return transactionManager;
    }

    @Bean
    @ConditionalOnMissingBean(value={Y9Context.class})
    public Y9Context y9Context() {
        return new Y9Context();
    }

    @ConfigurationProperties(value="spring.datasource.druid.y9-public")
    @Bean(name={"y9PublicDS"})
    @ConditionalOnMissingBean(name={"y9PublicDS"})
    public DruidDataSource y9PublicDS() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean(name={"jdbcTemplate4Public"})
    @ConditionalOnMissingBean(name={"jdbcTemplate4Public"})
    public JdbcTemplate jdbcTemplate4Public(@Qualifier(value="y9PublicDS") DruidDataSource y9PublicDS) {
        return new JdbcTemplate((DataSource)y9PublicDS);
    }

    @Primary
    @Bean(value={"y9TenantDataSource"})
    @ConditionalOnMissingBean(name={"y9TenantDataSource"})
    public DataSource y9TenantDataSource(@Qualifier(value="defaultDataSource") DruidDataSource defaultDataSource, @Qualifier(value="y9TenantDataSourceLookup") Y9TenantDataSourceLookup y9TenantDataSourceLookup) {
        return new Y9TenantDataSource(defaultDataSource, y9TenantDataSourceLookup);
    }

    @Bean(value={"y9TenantDataSourceLookup"})
    public Y9TenantDataSourceLookup y9TenantDataSourceLookup(@Qualifier(value="y9PublicDS") DruidDataSource ds, Environment environment) {
        return new Y9TenantDataSourceLookup(ds, environment.getProperty("y9.systemName"));
    }
}

