/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.id.impl;

import cn.hutool.core.util.IdUtil;
import lombok.Generated;
import net.risesoft.id.Y9IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdGenerator
implements Y9IdGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SnowflakeIdGenerator.class);
    private static final long START_STAMP = 1320076800000L;
    private static final long DATA_CENTER_BIT = 5L;
    private static final long WORKER_BIT = 5L;
    private static final long MACHINE_BIT = 10L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MAX_DATA_CENTER_NUM = 31L;
    private static final long MAX_WORKER_NUM = 31L;
    private static final long MAX_MACHINE_NUM = 1023L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long TIME_STAMP_LEFT = 22L;
    private final long machineId;
    private long sequence = 0L;
    private long lastStamp = -1L;

    public SnowflakeIdGenerator(long machineId) {
        if (machineId > 1023L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.machineId = machineId;
    }

    public SnowflakeIdGenerator() {
        this(SnowflakeIdGenerator.getMachineId());
    }

    private static long getMachineId() {
        long dataCenterId = IdUtil.getDataCenterId((long)31L);
        long workerId = IdUtil.getWorkerId((long)dataCenterId, (long)31L);
        return dataCenterId | workerId << 5;
    }

    private long getNewStamp() {
        return System.currentTimeMillis();
    }

    @Override
    public String getNextId() {
        Long id = this.nextId();
        return Long.toString(id);
    }

    private long getNextMill() {
        long mill = this.getNewStamp();
        while (mill <= this.lastStamp) {
            try {
                Thread.sleep(this.lastStamp - this.getNewStamp());
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
            mill = this.getNewStamp();
        }
        return mill;
    }

    private synchronized long nextId() {
        long currStamp = this.getNewStamp();
        if (currStamp < this.lastStamp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStamp == this.lastStamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currStamp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStamp = currStamp;
        return currStamp - 1320076800000L << 22 | this.machineId << 12 | this.sequence;
    }
}

