/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.rpc.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import net.risedata.rpc.exceptions.ConfigException;
import net.risedata.rpc.utils.LParameter;

public class MethodUtils {
    public static LParameter[] getParameters(Class<?> clazz, Method m) throws NotFoundException {
        int i;
        ClassPool pool = ClassPool.getDefault();
        Class<?>[] types = m.getParameterTypes();
        Annotation[][] as = new Annotation[types.length][];
        Class[][] generalType = new Class[types.length][];
        Parameter[] ps = m.getParameters();
        for (int i2 = 0; i2 < ps.length; ++i2) {
            as[i2] = ps[i2].getAnnotations();
            generalType[i2] = MethodUtils.getGeneralTypes(ps[i2].getParameterizedType().getTypeName());
        }
        pool.insertClassPath((ClassPath)new ClassClassPath(clazz));
        CtClass cc = pool.get(clazz.getName());
        CtMethod cm = cc.getDeclaredMethod(m.getName());
        MethodInfo methodInfo = cm.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        if (attr == null) {
            return null;
        }
        String[] parameterNames = new String[cm.getParameterTypes().length];
        int pos = Modifier.isStatic(cm.getModifiers()) ? 0 : 1;
        LParameter[] pss = new LParameter[cm.getParameterTypes().length];
        LParameter p = null;
        for (i = 0; i < attr.tableLength(); ++i) {
            if (attr.index(i) < pos || attr.index(i) >= parameterNames.length + pos) continue;
            parameterNames[attr.index((int)i) - pos] = attr.variableName(i);
        }
        for (i = 0; i < ps.length; ++i) {
            p = new LParameter();
            String pname = parameterNames[i];
            if (pname == null) {
                p.setParameterName(ps[i].getName());
            } else {
                p.setParameterName(pname.equals("this") ? "t" : pname);
            }
            p.setParameterType(types[i]);
            p.setAnnotations(as[i]);
            p.setGeneralType(generalType[i]);
            p.setGeneral(generalType[i] != null);
            pss[i] = p;
        }
        return pss;
    }

    public static Class<?>[] getGeneralTypes(String typeStr) {
        int last;
        int start = typeStr.indexOf("<");
        if (start != -1 && (last = typeStr.lastIndexOf(">")) > start) {
            String generalStr = typeStr.substring(start + 1, last);
            String[] types = generalStr.split(",");
            Class[] classes = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                try {
                    classes[i] = Class.forName(types[i].trim());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigException("parse GeneralType" + types[i] + "error:" + e.getMessage());
                }
            }
            return classes;
        }
        return null;
    }
}

