/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.rpc.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class KeyLock<K> {
    private Map<K, Semaphore> keys = new ConcurrentHashMap<K, Semaphore>();
    private Semaphore createLock = new Semaphore(1);

    public void lock(K k) {
        Semaphore lock = this.keys.get(k);
        if (lock == null) {
            this.createLock.acquireUninterruptibly();
            lock = this.keys.get(k);
            if (lock == null) {
                lock = new Semaphore(1);
                this.keys.put(k, lock);
            }
            this.createLock.release();
        }
        lock.acquireUninterruptibly();
    }

    public void unLock(K k) {
        Semaphore lock = this.keys.get(k);
        if (lock != null) {
            lock.release();
        }
    }
}

