/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.rpc.model;

import com.alibaba.fastjson.JSONObject;
import io.netty.util.CharsetUtil;
import net.risedata.rpc.model.Msg;

public class Response {
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    private int type;
    private int status;
    private String message;
    private long id;

    public static Response as(Msg msg) {
        return new Response(msg.getMsg());
    }

    public Response(byte[] jsonBytes) {
        JSONObject jsonObject = JSONObject.parseObject((String)new String(jsonBytes, CharsetUtil.UTF_8));
        this.message = jsonObject.getString("message");
        this.status = jsonObject.getInteger("status");
        this.type = jsonObject.getInteger("type");
        this.message = jsonObject.getString("message");
        this.id = jsonObject.getLong("id");
    }

    public byte[] toBytes() {
        return JSONObject.toJSONString((Object)this).getBytes(CharsetUtil.UTF_8);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Response(int status, String message, long id) {
        this.status = status;
        this.message = message;
        this.id = id;
    }

    public Response() {
    }

    public static int getSUCCESS() {
        return 0;
    }

    public static int getERROR() {
        return 1;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Msg asMsg() {
        byte[] bytes = this.toBytes();
        return new Msg(bytes.length, bytes);
    }

    public String toString() {
        return "Response{type=" + this.type + ", status=" + this.status + ", message='" + this.message + "', id=" + this.id + "}";
    }

    public long getId() {
        return this.id;
    }
}

