/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.rpc.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.netty.util.CharsetUtil;
import java.util.Arrays;
import net.risedata.rpc.model.Msg;

public class Request {
    public static final int RPC = 0;
    public static final int LISTENER = 1;
    private String url;
    private int type;
    private JSONArray args;
    private long id;

    public static Request as(Msg msg) {
        return new Request(msg.getMsg());
    }

    public Request() {
    }

    public Request(byte[] jsonBytes) {
        JSONObject jsonObject = JSONObject.parseObject((String)new String(jsonBytes, CharsetUtil.UTF_8));
        this.url = jsonObject.getString("url");
        this.args = jsonObject.getJSONArray("args");
        this.id = jsonObject.getLong("id");
        this.type = jsonObject.getInteger("type");
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Request(String url, long id, Object ... args) {
        this(url, 0, id, args);
    }

    public Request(String url, int type, long id, Object ... args) {
        this(url);
        this.type = type;
        if (args != null && args.length > 0) {
            JSONArray objects = new JSONArray();
            objects.addAll(Arrays.asList(args));
            this.args = objects;
        }
        this.id = id;
    }

    public Request(String url) {
        this.url = url;
    }

    public Msg asMsg() {
        byte[] bytes = this.toBytes();
        return new Msg(bytes.length, bytes);
    }

    public JSONArray getArgs() {
        return this.args;
    }

    public void setArgs(JSONArray args) {
        this.args = args;
    }

    public byte[] toBytes() {
        return JSON.toJSONString((Object)this).getBytes(CharsetUtil.UTF_8);
    }

    public Long getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        return "Request{url='" + this.url + "', type=" + this.type + ", args=" + this.args + ", id=" + this.id + "}";
    }
}

