/*
 * Decompiled with CFR 0.152.
 */
package net.risedata.rpc.factory;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import net.risedata.rpc.exceptions.ProxyException;
import net.risedata.rpc.factory.model.ReturnType;

public class ReturnTypeFactory {
    public static ReturnType parseInstance(Method m) {
        String genericityName = m.getGenericReturnType().getTypeName();
        Class<?> returnType = m.getReturnType();
        if (returnType == Object.class) {
            if (!genericityName.equals("java.lang.Object")) {
                int index = ReturnTypeFactory.findT(genericityName, m);
                if (index != -1) {
                    return new ReturnType(returnType, null, false, index, false);
                }
            } else {
                return new ReturnType(JSONObject.class, null, false, 0, true);
            }
            throw new ProxyException("An undefined type " + genericityName);
        }
        if (!genericityName.startsWith("java.util.Map")) {
            int end;
            int start = genericityName.indexOf("<");
            int n = end = start == -1 ? -1 : genericityName.lastIndexOf(">");
            if (start != -1 && end != -1) {
                int index = ReturnTypeFactory.findT(genericityName = genericityName.substring(start + 1, end), m);
                if (index == -1) {
                    start = genericityName.indexOf("<");
                    if (start != -1) {
                        genericityName = genericityName.substring(0, start);
                    }
                    try {
                        Class<?> genericityClass = Class.forName(genericityName);
                        return new ReturnType(returnType, genericityClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ProxyException("class not found " + e.getMessage());
                    }
                }
                return new ReturnType(returnType, null, false, index, true);
            }
        } else {
            return new ReturnType(returnType, Map.class);
        }
        return new ReturnType(returnType);
    }

    private static int findT(String genericityName, Method m) {
        Parameter[] ps = m.getParameters();
        for (int i = 0; i < ps.length; ++i) {
            if (!ps[i].getParameterizedType().getTypeName().contains("<" + genericityName + ">")) continue;
            return i;
        }
        return -1;
    }
}

