/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(String url) {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet get = new HttpGet(url);
        String responseContent = null;
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) return responseContent;
            HttpEntity entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return responseContent;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            return responseContent;
        }
        catch (IOException e) {
            e.printStackTrace();
            return responseContent;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (client != null) {
                        client.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String post(String url, HttpEntity data, ContentType ct) {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.setEntity(data);
        String responseContent = null;
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
            if (statusCode != 307) return responseContent;
            Header header = response.getFirstHeader("location");
            url = header.getValue();
            responseContent = this.post(url, data, ct);
            return responseContent;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            return responseContent;
        }
        catch (IOException e) {
            e.printStackTrace();
            return responseContent;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (client != null) {
                        client.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String postMap(String url, Map<String, Object> data) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        for (String key : data.keySet()) {
            params.add(new BasicNameValuePair(key, data.get(key).toString()));
        }
        UrlEncodedFormEntity urlEntity = null;
        try {
            urlEntity = new UrlEncodedFormEntity(params, "UTF-8");
            return this.post(url, (HttpEntity)urlEntity, ContentType.APPLICATION_FORM_URLENCODED);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public String postMapContainFile(String url, Map<String, Object> data, Map<String, File> files) {
        return HttpUtil.httpPostFormMultipart(url, data, files, null, null);
    }

    public String postParams(String url, List<NameValuePair> params) {
        UrlEncodedFormEntity urlEntity = null;
        try {
            urlEntity = new UrlEncodedFormEntity(params, "UTF-8");
            return this.post(url, (HttpEntity)urlEntity, ContentType.APPLICATION_FORM_URLENCODED);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String postJson(String url, String postData) {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(url);
        post.addHeader("Content-type", "application/json; charset=utf-8");
        post.setHeader("Accept", "application/json");
        StringEntity myEntity = new StringEntity(postData, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)myEntity);
        String responseContent = null;
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) return responseContent;
            HttpEntity entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return responseContent;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            return responseContent;
        }
        catch (IOException e) {
            e.printStackTrace();
            return responseContent;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (client != null) {
                        client.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String postString(String url, String postData) {
        StringEntity myEntity = new StringEntity(postData, ContentType.APPLICATION_FORM_URLENCODED);
        return this.post(url, (HttpEntity)myEntity, ContentType.APPLICATION_FORM_URLENCODED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostFormMultipart(String url, Map<String, Object> params, Map<String, File> files, Map<String, String> headers, String encode) {
        Set<String> keySet;
        String content = null;
        if (encode == null) {
            encode = "utf-8";
        }
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        HttpPost httpost = new HttpPost(url);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder mEntityBuilder = MultipartEntityBuilder.create();
        mEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        mEntityBuilder.setCharset(Charset.forName(encode));
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)Charset.forName(encode));
        if (params != null && params.size() > 0) {
            keySet = params.keySet();
            for (String key : keySet) {
                if (params.get(key) instanceof File) continue;
                mEntityBuilder.addTextBody(key, params.get(key).toString(), contentType);
            }
        }
        if (files != null && files.size() > 0) {
            keySet = files.keySet();
            for (String key : keySet) {
                File file = files.get(key);
                ContentType contentType1 = ContentType.create((String)"application/octet-stream", (Charset)Charset.forName(encode));
                mEntityBuilder.addBinaryBody(key, file, contentType1, file.getName());
            }
        }
        httpost.setEntity(mEntityBuilder.build());
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = closeableHttpClient.execute((HttpUriRequest)httpost);
            HttpEntity entity = httpResponse.getEntity();
            content = EntityUtils.toString((HttpEntity)entity, (String)encode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            closeableHttpClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }
}

