/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.rdbms.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import risesoft.data.transfer.core.util.RangeSplitUtil;
import risesoft.data.transfer.stream.rdbms.utils.DataBaseType;

public final class RdbmsRangeSplitWrap {
    public static List<String> splitAndWrap(String left, String right, int expectSliceNumber, String columnName, String quote, DataBaseType dataBaseType) {
        String[] tempResult = RangeSplitUtil.doAsciiStringSplit((String)left, (String)right, (int)expectSliceNumber);
        return RdbmsRangeSplitWrap.wrapRange(tempResult, columnName, quote, dataBaseType);
    }

    public static List<String> splitAndWrap(long left, long right, int expectSliceNumber, String columnName) {
        long[] tempResult = RangeSplitUtil.doLongSplit((long)left, (long)right, (int)expectSliceNumber);
        return RdbmsRangeSplitWrap.wrapRange(tempResult, columnName);
    }

    public static List<String> splitAndWrap(BigInteger left, BigInteger right, int expectSliceNumber, String columnName) {
        BigInteger[] tempResult = RangeSplitUtil.doBigIntegerSplit((BigInteger)left, (BigInteger)right, (int)expectSliceNumber);
        return RdbmsRangeSplitWrap.wrapRange(tempResult, columnName);
    }

    public static List<String> wrapRange(long[] rangeResult, String columnName) {
        String[] rangeStr = new String[rangeResult.length];
        int len = rangeResult.length;
        for (int i = 0; i < len; ++i) {
            rangeStr[i] = String.valueOf(rangeResult[i]);
        }
        return RdbmsRangeSplitWrap.wrapRange(rangeStr, columnName, "", null);
    }

    public static List<String> wrapRange(BigInteger[] rangeResult, String columnName) {
        String[] rangeStr = new String[rangeResult.length];
        int len = rangeResult.length;
        for (int i = 0; i < len; ++i) {
            rangeStr[i] = rangeResult[i].toString();
        }
        return RdbmsRangeSplitWrap.wrapRange(rangeStr, columnName, "", null);
    }

    public static List<String> wrapRange(String[] rangeResult, String columnName, String quote, DataBaseType dataBaseType) {
        if (null == rangeResult || rangeResult.length < 2) {
            throw new IllegalArgumentException(String.format("Parameter rangeResult can not be null and its length can not <2. detail:rangeResult=[%s].", StringUtils.join((Object[])rangeResult, (String)",")));
        }
        ArrayList<String> result = new ArrayList<String>();
        if (2 == rangeResult.length) {
            result.add(String.format(" (%s%s%s <= %s AND %s <= %s%s%s) ", quote, RdbmsRangeSplitWrap.quoteConstantValue(rangeResult[0], dataBaseType), quote, columnName, columnName, quote, RdbmsRangeSplitWrap.quoteConstantValue(rangeResult[1], dataBaseType), quote));
            return result;
        }
        int len = rangeResult.length - 2;
        for (int i = 0; i < len; ++i) {
            result.add(String.format(" (%s%s%s <= %s AND %s < %s%s%s) ", quote, RdbmsRangeSplitWrap.quoteConstantValue(rangeResult[i], dataBaseType), quote, columnName, columnName, quote, RdbmsRangeSplitWrap.quoteConstantValue(rangeResult[i + 1], dataBaseType), quote));
        }
        result.add(String.format(" (%s%s%s <= %s AND %s <= %s%s%s) ", quote, RdbmsRangeSplitWrap.quoteConstantValue(rangeResult[rangeResult.length - 2], dataBaseType), quote, columnName, columnName, quote, RdbmsRangeSplitWrap.quoteConstantValue(rangeResult[rangeResult.length - 1], dataBaseType), quote));
        return result;
    }

    public static String wrapFirstLastPoint(String firstPoint, String lastPoint, String columnName, String quote, DataBaseType dataBaseType) {
        return String.format(" ((%s < %s%s%s) OR (%s%s%s < %s)) ", columnName, quote, RdbmsRangeSplitWrap.quoteConstantValue(firstPoint, dataBaseType), quote, quote, RdbmsRangeSplitWrap.quoteConstantValue(lastPoint, dataBaseType), quote, columnName);
    }

    public static String wrapFirstLastPoint(Long firstPoint, Long lastPoint, String columnName) {
        return RdbmsRangeSplitWrap.wrapFirstLastPoint(firstPoint.toString(), lastPoint.toString(), columnName, "", null);
    }

    public static String wrapFirstLastPoint(BigInteger firstPoint, BigInteger lastPoint, String columnName) {
        return RdbmsRangeSplitWrap.wrapFirstLastPoint(firstPoint.toString(), lastPoint.toString(), columnName, "", null);
    }

    private static String quoteConstantValue(String aString, DataBaseType dataBaseType) {
        if (null == dataBaseType) {
            return aString;
        }
        if (dataBaseType.equals((Object)DataBaseType.MySql)) {
            return aString.replace("'", "''").replace("\\", "\\\\");
        }
        if (dataBaseType.equals((Object)DataBaseType.Oracle) || dataBaseType.equals((Object)DataBaseType.SQLServer) || dataBaseType.equals((Object)DataBaseType.RDBMS)) {
            return aString.replace("'", "''");
        }
        return aString;
    }
}

