/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.rdbms.out.mysql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.stream.out.DataOutputStream;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.stream.rdbms.out.RdbmsDataOutputStreamFactory;
import risesoft.data.transfer.stream.rdbms.out.mysql.MySqlUpadateDataOutputStream;
import risesoft.data.transfer.stream.rdbms.utils.DBUtil;

public class MySqlDataOutputStreamFactory
extends RdbmsDataOutputStreamFactory {
    public MySqlDataOutputStreamFactory(Configuration configuration, JobContext jobContext) {
        super(configuration, jobContext);
    }

    @Override
    protected void createUpdate(int size) {
        int i;
        this.idField = Arrays.asList(MySqlDataOutputStreamFactory.getStrings(this.writerType, "update"));
        this.updateField = new ArrayList();
        for (String columnHolder : (List)this.resultSetMetaData.getLeft()) {
            if (this.idField.contains(columnHolder)) continue;
            this.updateField.add(columnHolder);
        }
        StringBuilder sb = new StringBuilder("insert into ").append(this.tableName).append(" (").append(StringUtils.join((Iterable)((Iterable)this.resultSetMetaData.getLeft()), (String)",")).append(") values (");
        for (i = 0; i < size; ++i) {
            sb.append("?");
            if (i == size - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        sb.append(" ON DUPLICATE KEY UPDATE ");
        for (i = 0; i < this.updateField.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append((String)this.updateField.get(i) + " = values(" + (String)this.updateField.get(i) + ")");
        }
        this.workSql = sb.toString();
        if (this.logger.isInfo()) {
            this.logger.info((Object)this, "mysql worksql:" + this.workSql);
        }
    }

    @Override
    protected DataOutputStream getUpdateStream() {
        return new MySqlUpadateDataOutputStream(DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.userName, this.password), this.workSql, (Triple<List<String>, List<Integer>, List<String>>)this.resultSetMetaData, this.createColumnHandles, this.dataBaseType, this.logger);
    }
}

