/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.rdbms.out;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.FrameworkErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.stream.out.DataOutputStream;
import risesoft.data.transfer.core.stream.out.DataOutputStreamFactory;
import risesoft.data.transfer.core.util.ClassTools;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.core.util.ValueUtils;
import risesoft.data.transfer.stream.rdbms.out.InsertRdbmsDataOutputStream;
import risesoft.data.transfer.stream.rdbms.out.ReplaceRdbmsDataOutputStream;
import risesoft.data.transfer.stream.rdbms.out.UpdateRdbmsDataOutputStream;
import risesoft.data.transfer.stream.rdbms.out.columns.PreparedStatementHandle;
import risesoft.data.transfer.stream.rdbms.utils.DBUtil;
import risesoft.data.transfer.stream.rdbms.utils.DataBaseType;

public class RdbmsDataOutputStreamFactory
implements DataOutputStreamFactory {
    private static final List<PreparedStatementHandle> COLUMN_HANDLES;
    public static final byte[] EMPTY_CHAR_ARRAY;
    protected String jdbcUrl;
    protected String password;
    protected String userName;
    protected DataBaseType dataBaseType;
    protected String tableName;
    protected String writerType;
    protected Map<String, PreparedStatementHandle> createColumnHandles;
    protected Triple<List<String>, List<Integer>, List<String>> resultSetMetaData;
    protected List<String> columns;
    protected String workSql;
    protected Logger logger;
    protected List<String> idField;
    protected List<String> updateField;

    public RdbmsDataOutputStreamFactory(Configuration configuration, JobContext jobContext) {
        this.jdbcUrl = (String)ValueUtils.getRequired((Object)configuration.getString("jdbcUrl"), (String)"\u7f3a\u5931jdbcUrl");
        this.password = (String)ValueUtils.getRequired((Object)configuration.getString("password"), (String)"\u7f3a\u5931password");
        this.userName = (String)ValueUtils.getRequired((Object)configuration.getString("userName"), (String)"\u7f3a\u5931userName");
        this.dataBaseType = DataBaseType.RDBMS;
        this.tableName = (String)ValueUtils.getRequired((Object)configuration.getString("tableName"), (String)"\u7f3a\u5931tableName");
        this.writerType = configuration.getString("writerType", "insert");
        this.columns = (List)ValueUtils.getRequired((Object)configuration.getList("column", String.class), (String)"\u7f3a\u5931\u5217\u914d\u7f6e");
        this.logger = jobContext.getLoggerFactory().getLogger(RdbmsDataOutputStreamFactory.class);
        if (this.logger.isInfo()) {
            this.logger.info((Object)this, "create RdbmsDataOutputStreamFactory \njdbcUrl:" + this.jdbcUrl + " \ntableName:" + this.tableName + "\ncolumns:" + this.columns + "\nwriterType:" + this.writerType);
        }
    }

    protected void createInsertSql(int size) {
        StringBuilder sb = new StringBuilder("insert into ").append(this.tableName).append(" (").append(StringUtils.join((Iterable)((Iterable)this.resultSetMetaData.getLeft()), (String)",")).append(") values (");
        for (int i = 0; i < size; ++i) {
            sb.append("?");
            if (i == size - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        this.workSql = sb.toString();
        if (this.logger.isInfo()) {
            this.logger.info((Object)this, "worksql:" + this.workSql);
        }
    }

    protected void createReplace(int size) {
        int i;
        this.idField = Arrays.asList(RdbmsDataOutputStreamFactory.getStrings(this.writerType, "replace"));
        this.updateField = new ArrayList<String>();
        for (String columnHolder : (List)this.resultSetMetaData.getLeft()) {
            if (this.idField.contains(columnHolder)) continue;
            this.updateField.add(columnHolder);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("update " + this.tableName).append(" set ");
        for (i = 0; i < this.updateField.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.updateField.get(i) + " = ? ");
        }
        sb.append("where");
        for (i = 0; i < this.idField.size(); ++i) {
            if (i != 0) {
                sb.append(" and ");
            }
            sb.append(this.updateField.get(i) + " = ? ");
        }
        this.workSql = sb.toString();
        if (this.logger.isInfo()) {
            this.logger.info((Object)this, "worksql:" + this.workSql);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createUpdate(int size) {
        void var8_14;
        this.idField = Arrays.asList(RdbmsDataOutputStreamFactory.getStrings(this.writerType, "update"));
        this.updateField = new ArrayList<String>();
        for (String columnHolder : (List)this.resultSetMetaData.getLeft()) {
            if (this.idField.contains(columnHolder)) continue;
            this.updateField.add(columnHolder);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MERGE INTO " + this.tableName + " A USING ( SELECT ");
        boolean first = true;
        boolean first1 = true;
        StringBuilder str = new StringBuilder();
        StringBuilder update = new StringBuilder();
        for (String string : this.idField) {
            if (!first) {
                sb.append(",");
                str.append(" AND ");
            } else {
                first = false;
            }
            str.append("TMP.").append(string);
            sb.append("?");
            str.append(" = ");
            sb.append(" AS ");
            str.append("A.").append(string);
            sb.append(string);
        }
        for (String string : this.updateField) {
            if (!first1) {
                update.append(",");
            } else {
                first1 = false;
            }
            update.append(string);
            update.append(" = ");
            update.append("?");
        }
        sb.append(" FROM DUAL ) TMP ON (");
        sb.append((CharSequence)str);
        sb.append(" ) WHEN MATCHED THEN UPDATE SET ");
        sb.append((CharSequence)update);
        sb.append(" where ");
        first = true;
        for (String columnHolder : this.updateField) {
            if (!first) {
                sb.append(" or ");
            } else {
                first = false;
            }
            PreparedStatementHandle preparedStatementHandle = this.createColumnHandles.get(columnHolder);
            if (preparedStatementHandle.isBigType()) {
                sb.append("length(" + columnHolder + ") != length(?)");
                continue;
            }
            sb.append(columnHolder + " != ?");
        }
        sb.append(" WHEN NOT MATCHED THEN ").append("INSERT (").append(StringUtils.join((Iterable)((Iterable)this.resultSetMetaData.getLeft()), (String)",")).append(") VALUES(");
        boolean bl = false;
        while (var8_14 < size) {
            sb.append("?");
            if (var8_14 != size - 1) {
                sb.append(",");
            }
            ++var8_14;
        }
        sb.append(")");
        this.workSql = sb.toString();
        if (this.logger.isInfo()) {
            this.logger.info((Object)this, "worksql:" + this.workSql);
        }
    }

    public void init() {
        block6: {
            this.createColumnHandles = new HashMap<String, PreparedStatementHandle>();
            try {
                this.logger.debug((Object)this, "getMetaData");
                this.resultSetMetaData = DBUtil.getColumnMetaData(this.dataBaseType, this.jdbcUrl, this.userName, this.password, this.tableName, StringUtils.join(this.columns, (String)","));
                int size = ((List)this.resultSetMetaData.getRight()).size();
                for (int i = 0; i < size; ++i) {
                    this.createColumnHandles.put((String)((List)this.resultSetMetaData.getLeft()).get(i), this.getHandle((Integer)((List)this.resultSetMetaData.getMiddle()).get(i)));
                }
                this.logger.debug((Object)this, "create writer sql");
                if (this.writerType.equals("insert")) {
                    this.createInsertSql(size);
                    break block6;
                }
                if (this.writerType.startsWith("update")) {
                    this.createUpdate(size);
                    break block6;
                }
                if (this.writerType.startsWith("replace")) {
                    this.createUpdate(size);
                    break block6;
                }
                this.logger.error((Object)this, "\u672a\u8bc6\u522b\u7684\u8f93\u51fa\u7c7b\u578b" + this.writerType);
                throw new RuntimeException("\u672a\u8bc6\u522b\u7684\u8f93\u51fa\u7c7b\u578b" + this.writerType);
            }
            catch (Exception e) {
                throw TransferException.as((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, (String)("\u521d\u59cb\u5316\u6570\u636e\u5e93\u8f93\u5165\u6d41\u5de5\u5382\u5931\u8d25\u5f02\u5e38\u4fe1\u606f" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static String[] getStrings(String merge, String pre) {
        merge = merge.replace(pre, "");
        merge = merge.replace("(", "");
        merge = merge.replace(")", "");
        merge = merge.replace(" ", "");
        return merge.split(",");
    }

    private PreparedStatementHandle getHandle(int type) {
        for (PreparedStatementHandle preparedStatementHandle : COLUMN_HANDLES) {
            if (!preparedStatementHandle.isHandle(type)) continue;
            return preparedStatementHandle;
        }
        throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("\u65e0\u6cd5\u5904\u7406\u7684\u7c7b\u578b:" + type));
    }

    public void close() throws Exception {
        this.logger.info((Object)this, "close");
    }

    protected DataOutputStream getInsertStream() {
        return new InsertRdbmsDataOutputStream(DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.userName, this.password), this.workSql, this.resultSetMetaData, this.createColumnHandles, this.dataBaseType, this.logger);
    }

    protected DataOutputStream getUpdateStream() {
        return new UpdateRdbmsDataOutputStream(DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.userName, this.password), this.workSql, this.resultSetMetaData, this.createColumnHandles, this.dataBaseType, this.idField, this.updateField, this.logger);
    }

    protected DataOutputStream getReplaceStream() {
        return new ReplaceRdbmsDataOutputStream(DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.userName, this.password), this.workSql, this.resultSetMetaData, this.createColumnHandles, this.dataBaseType, this.idField, this.updateField, this.logger);
    }

    public DataOutputStream getStream() {
        this.logger.debug((Object)this, "getstream");
        if (this.writerType.equals("insert")) {
            return this.getInsertStream();
        }
        if (this.writerType.startsWith("update")) {
            return this.getUpdateStream();
        }
        if (this.writerType.startsWith("replace")) {
            return this.getReplaceStream();
        }
        throw TransferException.as((ErrorCode)CommonErrorCode.CONFIG_ERROR, (String)("\u65e0\u6548\u7684\u8f93\u51fa\u7c7b\u578b" + this.writerType));
    }

    static {
        EMPTY_CHAR_ARRAY = new byte[0];
        try {
            COLUMN_HANDLES = ClassTools.getInstancesOfPack((String)"risesoft.data.transfer.stream.rdbms.out.columns.impl", PreparedStatementHandle.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("\u52a0\u8f7d\u6570\u636e\u5e93\u5904\u7406\u5de5\u5382\u5931\u8d25\u7a0b\u5e8f\u9519\u8bef!");
        }
    }
}

