/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.rdbms.out;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.record.Ack;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.stream.out.DataOutputStream;
import risesoft.data.transfer.stream.rdbms.out.columns.PreparedStatementHandle;
import risesoft.data.transfer.stream.rdbms.utils.DataBaseType;

public abstract class RdbmsDataOutputStream
implements DataOutputStream {
    protected Map<String, PreparedStatementHandle> createColumnHandles;
    protected Triple<List<String>, List<Integer>, List<String>> resultSetMetaData;
    protected Connection connection;
    protected String workSql;
    protected DataBaseType dataBaseType;
    protected Logger logger;

    public RdbmsDataOutputStream(Connection connection, String workSql, Triple<List<String>, List<Integer>, List<String>> resultSetMetaData, Map<String, PreparedStatementHandle> createColumnHandles, DataBaseType dataBaseType, Logger logger) {
        this.connection = connection;
        this.workSql = workSql;
        this.createColumnHandles = createColumnHandles;
        this.resultSetMetaData = resultSetMetaData;
        this.dataBaseType = dataBaseType;
        this.logger = logger;
    }

    public void close() throws Exception {
        if (this.connection.isClosed()) {
            return;
        }
        this.connection.close();
        this.logger.debug((Object)this, "close stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writer(List<Record> records, Ack ack) {
        Statement preparedStatement = null;
        try {
            this.connection.setAutoCommit(false);
            this.logger.debug((Object)this, " create Statement");
            preparedStatement = this.connection.prepareStatement(this.workSql);
            for (Record record : records) {
                preparedStatement = this.fillPreparedStatement((PreparedStatement)preparedStatement, record);
                preparedStatement.addBatch();
            }
            if (this.logger.isDebug()) {
                this.logger.debug((Object)this, "executeBatch: " + records.size());
            }
            preparedStatement.executeBatch();
            this.connection.commit();
            ack.confirm(records);
            if (this.logger.isDebug()) {
                this.logger.debug((Object)this, "confirm: " + records.size());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)this, e.getMessage());
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"sql\u56de\u6eda\u5931\u8d25", (Throwable)e1);
            }
            this.doOneWriter(records, ack);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOneWriter(List<Record> records, Ack ack) {
        Statement preparedStatement = null;
        try {
            this.connection.setAutoCommit(true);
            if (this.logger.isDebug()) {
                this.logger.debug((Object)this, "doOneWriter" + records.size());
            }
            preparedStatement = this.connection.prepareStatement(this.workSql);
            for (Record record : records) {
                try {
                    preparedStatement = this.fillPreparedStatement((PreparedStatement)preparedStatement, record);
                    preparedStatement.execute();
                    ack.confirm(record);
                }
                catch (Exception e) {
                    this.logger.error((Object)this, record + " error:" + e.getMessage());
                    ack.cancel(record, (Throwable)e, e.toString());
                }
                finally {
                    preparedStatement.clearParameters();
                }
            }
            if (this.logger.isDebug()) {
                this.logger.debug((Object)this, "doOneWriter end" + records.size());
            }
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"\u6267\u884c\u63d2\u5165\u62a5\u9519", (Throwable)e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected abstract PreparedStatement fillPreparedStatement(PreparedStatement var1, Record var2) throws Exception;

    protected Map<String, Column> getRecordMap(Record record) {
        HashMap<String, Column> recordMap = new HashMap<String, Column>();
        for (int i = 0; i < record.getColumnNumber(); ++i) {
            recordMap.put(record.getColumn(i).getName(), record.getColumn(i));
        }
        return recordMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writer(Record record, Ack ack) {
        Statement preparedStatement = null;
        try {
            this.connection.setAutoCommit(true);
            preparedStatement = this.connection.prepareStatement(this.workSql);
            preparedStatement = this.fillPreparedStatement((PreparedStatement)preparedStatement, record);
            preparedStatement.execute();
            ack.confirm(record);
        }
        catch (Exception e) {
            e.printStackTrace();
            ack.cancel(record, (Throwable)e, e.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

