/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.rdbms.in;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import risesoft.data.transfer.core.data.Data;
import risesoft.data.transfer.core.data.StringData;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.FrameworkErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.stream.in.DataInputStream;
import risesoft.data.transfer.core.stream.in.DataInputStreamFactory;
import risesoft.data.transfer.core.util.ClassTools;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.core.util.ValueUtils;
import risesoft.data.transfer.stream.rdbms.in.RdbmsDataInputStream;
import risesoft.data.transfer.stream.rdbms.in.columns.CreateColumnHandle;
import risesoft.data.transfer.stream.rdbms.utils.DBUtil;
import risesoft.data.transfer.stream.rdbms.utils.DBUtilErrorCode;
import risesoft.data.transfer.stream.rdbms.utils.DataBaseType;
import risesoft.data.transfer.stream.rdbms.utils.RdbmsException;
import risesoft.data.transfer.stream.rdbms.utils.RdbmsRangeSplitWrap;

public class RdbmsDataInputStreamFactory
implements DataInputStreamFactory {
    private static final List<CreateColumnHandle> COLUMN_HANDLES;
    public static final byte[] EMPTY_CHAR_ARRAY;
    private String jdbcUrl;
    private String password;
    private String userName;
    private DataBaseType dataBaseType;
    private String selectSql;
    private String where;
    private String splitPk;
    private Boolean precise;
    private int splitFactor;
    private String tableName;
    private Connection connection;
    private List<CreateColumnHandle> createColumnHandles;
    private int tableNumber;
    private int fetchSize;
    private double samplePercentage;
    private String mandatoryEncoding;
    private Logger logger;

    public RdbmsDataInputStreamFactory(Configuration configuration, LoggerFactory loggerFactory) {
        this.jdbcUrl = (String)ValueUtils.getRequired((Object)configuration.getString("jdbcUrl"), (String)"\u7f3a\u5931jdbcUrl");
        this.password = (String)ValueUtils.getRequired((Object)configuration.getString("password"), (String)"\u7f3a\u5931password");
        this.userName = (String)ValueUtils.getRequired((Object)configuration.getString("userName"), (String)"\u7f3a\u5931userName");
        this.dataBaseType = DataBaseType.RDBMS;
        this.tableName = (String)ValueUtils.getRequired((Object)configuration.getString("tableName"), (String)"\u7f3a\u5931tableName");
        this.selectSql = "select " + StringUtils.join((Iterable)((Iterable)ValueUtils.getRequired((Object)configuration.getList("column", String.class), (String)"\u7f3a\u5931column")), (String)",") + " from " + this.tableName;
        this.where = configuration.getString("where", "").trim();
        this.splitPk = configuration.getString("splitPk");
        this.precise = configuration.getBool("precise", false);
        this.splitFactor = configuration.getInt("splitFactor", -1);
        this.tableNumber = configuration.getInt("tableNumber", -1);
        this.fetchSize = configuration.getInt("fetchSize", 32);
        this.samplePercentage = configuration.getDouble("samplePercentage", 0.1);
        this.mandatoryEncoding = configuration.getString("mandatoryEncoding");
        this.logger = loggerFactory.getLogger(configuration.getString("name", "RdbmsDataInputStreamFactory"));
        if (this.logger.isInfo()) {
            this.logger.info((Object)this, "create rdbmsDataInputStreamFactory jdbcUrl:" + this.jdbcUrl + "\n table:" + this.tableName + " \n select sql: " + this.selectSql + "\n where" + this.where + "\n fetchSize: " + this.fetchSize);
        }
    }

    public void init() {
        this.createColumnHandles = new ArrayList<CreateColumnHandle>();
        try {
            this.logger.debug((Object)this, "getConnection");
            this.connection = DBUtil.getConnection(DataBaseType.RDBMS, this.jdbcUrl, this.userName, this.password);
            if (this.logger.isDebug()) {
                this.logger.debug((Object)this, "get metaData:" + this.selectSql + " where 1=2");
            }
            ResultSet resultSet = DBUtil.query(this.connection, this.selectSql + " where 1=2");
            ResultSetMetaData metaData = resultSet.getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                int tmpType = metaData.getColumnType(i);
                for (CreateColumnHandle createColumnHandle : COLUMN_HANDLES) {
                    if (!createColumnHandle.isHandle(tmpType)) continue;
                    this.createColumnHandles.add(createColumnHandle);
                    break;
                }
                if (this.createColumnHandles.size() == i) continue;
                throw TransferException.as((ErrorCode)DBUtilErrorCode.UNSUPPORTED_TYPE, (String)String.format("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u7684\u5217\u914d\u7f6e\u4fe1\u606f\u6709\u8bef.  \u4e0d\u652f\u6301\u6570\u636e\u5e93\u8bfb\u53d6\u8fd9\u79cd\u5b57\u6bb5\u7c7b\u578b. \u5b57\u6bb5\u540d:[%s], \u5b57\u6bb5\u540d\u79f0:[%s], \u5b57\u6bb5Java\u7c7b\u578b:[%s]. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u6570\u636e\u5e93\u51fd\u6570\u5c06\u5176\u8f6c\u6362\u652f\u6301\u7684\u7c7b\u578b \u6216\u8005\u4e0d\u540c\u6b65\u8be5\u5b57\u6bb5 .", metaData.getColumnLabel(i), metaData.getColumnType(i), metaData.getColumnClassName(i)));
            }
            this.logger.info((Object)this, "\u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, (String)("\u521d\u59cb\u5316\u6570\u636e\u5e93\u8f93\u5165\u6d41\u5de5\u5382\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public DataInputStream getStream() {
        return new RdbmsDataInputStream(DBUtil.getConnection(this.dataBaseType, this.jdbcUrl, this.userName, this.password), this.selectSql, this.fetchSize, this.createColumnHandles, this.mandatoryEncoding, this.logger);
    }

    public void close() throws Exception {
        if (this.connection.isClosed()) {
            return;
        }
        this.connection.close();
    }

    public List<Data> splitToData(int executorSize) throws Exception {
        boolean isSub;
        int numberSize = this.tableNumber != -1 ? this.tableNumber : (this.splitFactor != -1 ? executorSize * this.splitFactor : 1);
        boolean bl = isSub = numberSize >= 1 && StringUtils.isNotEmpty((CharSequence)this.splitPk);
        if (isSub) {
            ResultSetMetaData rsMetaData;
            ResultSet resultSet;
            if (this.logger.isInfo()) {
                this.logger.info((Object)this, "sub data to " + numberSize);
            }
            List querys = null;
            if (this.precise.booleanValue()) {
                String fu;
                resultSet = DBUtil.query(this.connection, "SELECT distinct " + this.splitPk + " from " + this.tableName);
                querys = new ArrayList();
                rsMetaData = resultSet.getMetaData();
                String string = fu = this.isStringType(rsMetaData.getColumnType(1)) ? "'%S'" : "%S";
                while (resultSet.next()) {
                    querys.add((Data)new StringData(String.format(" %S = " + fu, this.splitPk, resultSet.getObject(this.splitPk))));
                }
                resultSet.close();
            } else {
                String pk = RdbmsDataInputStreamFactory.genPKSql(this.splitPk, this.tableName, this.where);
                if (this.dataBaseType == DataBaseType.Oracle) {
                    querys = StringData.as(this.genSplitSqlForOracle(this.splitPk, this.tableName, this.where, numberSize));
                    return querys;
                }
                resultSet = DBUtil.query(this.connection, pk);
                rsMetaData = resultSet.getMetaData();
                ImmutablePair minMaxPK = null;
                boolean isStringType = false;
                boolean isLongType = false;
                if (!this.isPKTypeValid(rsMetaData)) {
                    throw new TransferException((ErrorCode)CommonErrorCode.CONFIG_ERROR, "\u914d\u7f6e\u7684splitPk\u4e0d\u652f\u6301\u6b64\u7c7b\u578b");
                }
                if (this.isStringType(rsMetaData.getColumnType(1))) {
                    while (DBUtil.asyncResultSetNext(resultSet)) {
                        minMaxPK = new ImmutablePair((Object)resultSet.getString(1), (Object)resultSet.getString(2));
                    }
                    isStringType = true;
                } else if (this.isLongType(rsMetaData.getColumnType(1))) {
                    isLongType = true;
                    while (DBUtil.asyncResultSetNext(resultSet)) {
                        minMaxPK = new ImmutablePair((Object)resultSet.getString(1), (Object)resultSet.getString(2));
                        String minMax = resultSet.getString(1) + resultSet.getString(2);
                        if (!StringUtils.contains((CharSequence)minMax, (int)46)) continue;
                        throw TransferException.as((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, (String)("\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk)\u6709\u8bef. \u56e0\u4e3a\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk) \u7c7b\u578b\u4e0d\u652f\u6301. \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406..pkSql:" + pk + " type:" + rsMetaData.getColumnType(1)));
                    }
                }
                resultSet.close();
                if (isStringType) {
                    querys = StringData.as(RdbmsRangeSplitWrap.splitAndWrap(String.valueOf(minMaxPK.getLeft()), String.valueOf(minMaxPK.getRight()), numberSize, this.splitPk, "'", this.dataBaseType));
                } else if (isLongType) {
                    querys = StringData.as(RdbmsRangeSplitWrap.splitAndWrap(new BigInteger(minMaxPK.getLeft().toString()), new BigInteger(minMaxPK.getRight().toString()), numberSize, this.splitPk));
                } else {
                    throw TransferException.as((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, (String)"\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk) \u7c7b\u578b  \u4e0d\u652f\u6301 \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406.");
                }
            }
            String whereStr = " where ";
            StringBuilder tmpWhereSB = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)this.where)) {
                if (!this.where.toLowerCase().startsWith("where")) {
                    tmpWhereSB.append(" where ").append(this.where);
                } else {
                    tmpWhereSB.append(this.where);
                }
                whereStr = " and ";
            }
            String tmpWhere = tmpWhereSB.toString();
            for (Data data : querys) {
                StringData stringData = (StringData)data;
                stringData.setValue(StringUtils.isEmpty((CharSequence)tmpWhere) ? whereStr + stringData.getValue() : tmpWhere + whereStr + stringData.getValue());
            }
            if (this.logger.isInfo()) {
                this.logger.info((Object)this, "sub data end: " + querys.size());
            }
            return querys;
        }
        this.close();
        this.logger.info((Object)this, "no sub data");
        return Arrays.asList(new StringData((String)(StringUtils.isEmpty((CharSequence)this.where) ? " " : " where " + this.where)));
    }

    private boolean isPKTypeValid(ResultSetMetaData rsMetaData) {
        boolean ret = false;
        try {
            int minType = rsMetaData.getColumnType(1);
            int maxType = rsMetaData.getColumnType(2);
            boolean isStringType = this.isStringType(minType);
            boolean isNumberType = this.isLongType(minType);
            if (minType == maxType && (isNumberType || isStringType)) {
                ret = true;
            }
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, (String)"\u83b7\u53d6\u5207\u5206\u4e3b\u952e(splitPk)\u5b57\u6bb5\u7c7b\u578b\u5931\u8d25. \u8be5\u9519\u8bef\u901a\u5e38\u662f\u7cfb\u7edf\u5e95\u5c42\u5f02\u5e38\u5bfc\u81f4. \u8bf7\u8054\u7cfbDBA\u5904\u7406.");
        }
        return ret;
    }

    private static String genPKSql(String splitPK, String table, String where) {
        String minMaxTemplate = "SELECT MIN(%s),MAX(%s) FROM %s";
        String pkRangeSQL = String.format(minMaxTemplate, splitPK, splitPK, table);
        if (StringUtils.isNotBlank((CharSequence)where)) {
            pkRangeSQL = String.format("%s WHERE (%s AND %s IS NOT NULL)", pkRangeSQL, where, splitPK);
        }
        return pkRangeSQL;
    }

    private List<String> genSplitSqlForOracle(String splitPK, String table, String where, int adviceNum) {
        if (adviceNum < 1) {
            throw new IllegalArgumentException(String.format("\u5207\u5206\u4efd\u6570\u4e0d\u80fd\u5c0f\u4e8e1. \u6b64\u5904:adviceNum=[%s].", adviceNum));
        }
        if (adviceNum == 1) {
            return null;
        }
        String whereSql = String.format("%s IS NOT NULL", splitPK);
        whereSql = StringUtils.isNotBlank((CharSequence)where) ? String.format(" WHERE (%s) AND (%s) ", whereSql, where) : String.format(" WHERE %s ", whereSql);
        String sampleSqlTemplate = "SELECT * FROM ( SELECT %s FROM %s SAMPLE (%s) %s ORDER BY DBMS_RANDOM.VALUE) WHERE ROWNUM <= %s ORDER by %s ASC";
        String splitSql = String.format(sampleSqlTemplate, splitPK, table, this.samplePercentage, whereSql, adviceNum, splitPK);
        ResultSet rs = null;
        ArrayList<ImmutablePair> splitedRange = new ArrayList<ImmutablePair>();
        try {
            try {
                rs = DBUtil.query(this.connection, splitSql, this.fetchSize);
            }
            catch (Exception e) {
                throw RdbmsException.asQueryException(this.dataBaseType, e, splitSql, table, this.userName);
            }
            ResultSetMetaData rsMetaData = rs.getMetaData();
            while (DBUtil.asyncResultSetNext(rs)) {
                ImmutablePair eachPoint = new ImmutablePair(rs.getObject(1), (Object)rsMetaData.getColumnType(1));
                splitedRange.add(eachPoint);
            }
        }
        catch (TransferException e) {
            throw e;
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, (String)"DataX\u5c1d\u8bd5\u5207\u5206\u8868\u53d1\u751f\u9519\u8bef. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", (Throwable)e);
        }
        ArrayList<String> rangeSql = new ArrayList<String>();
        int splitedRangeSize = splitedRange.size();
        if (splitedRangeSize >= 2) {
            if (this.isLongType((Integer)((Pair)splitedRange.get(0)).getRight())) {
                BigInteger[] integerPoints = new BigInteger[splitedRange.size()];
                for (int i = 0; i < splitedRangeSize; ++i) {
                    integerPoints[i] = new BigInteger(((Pair)splitedRange.get(i)).getLeft().toString());
                }
                rangeSql.addAll(RdbmsRangeSplitWrap.wrapRange(integerPoints, splitPK));
                rangeSql.add(RdbmsRangeSplitWrap.wrapFirstLastPoint(integerPoints[0], integerPoints[splitedRangeSize - 1], splitPK));
            } else if (this.isStringType((Integer)((Pair)splitedRange.get(0)).getRight())) {
                String[] stringPoints = new String[splitedRange.size()];
                for (int i = 0; i < splitedRangeSize; ++i) {
                    stringPoints[i] = new String(((Pair)splitedRange.get(i)).getLeft().toString());
                }
                rangeSql.addAll(RdbmsRangeSplitWrap.wrapRange(stringPoints, splitPK, "'", this.dataBaseType));
                rangeSql.add(RdbmsRangeSplitWrap.wrapFirstLastPoint(stringPoints[0], stringPoints[splitedRangeSize - 1], splitPK, "'", this.dataBaseType));
            } else {
                throw TransferException.as((ErrorCode)DBUtilErrorCode.ILLEGAL_SPLIT_PK, (String)"\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk)\u6709\u8bef. \u56e0\u4e3a\u60a8\u914d\u7f6e\u7684\u5207\u5206\u4e3b\u952e(splitPk) \u7c7b\u578b \u4e0d\u652f\u6301.  \u4ec5\u652f\u6301\u5207\u5206\u4e3b\u952e\u4e3a\u4e00\u4e2a,\u5e76\u4e14\u7c7b\u578b\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32\u7c7b\u578b. \u8bf7\u5c1d\u8bd5\u4f7f\u7528\u5176\u4ed6\u7684\u5207\u5206\u4e3b\u952e\u6216\u8005\u8054\u7cfb DBA \u8fdb\u884c\u5904\u7406.");
            }
        }
        return rangeSql;
    }

    private boolean isStringType(int type) {
        return type == 1 || type == -15 || type == 12 || type == -1 || type == -9;
    }

    private boolean isLongType(int type) {
        boolean isValidLongType = type == -5 || type == 4 || type == 5 || type == -6;
        switch (this.dataBaseType) {
            case Oracle: 
            case RDBMS: {
                isValidLongType |= type == 2;
                isValidLongType |= type == 3;
                break;
            }
        }
        return isValidLongType;
    }

    static {
        EMPTY_CHAR_ARRAY = new byte[0];
        try {
            COLUMN_HANDLES = ClassTools.getInstancesOfPack((String)"risesoft.data.transfer.stream.rdbms.in.columns.impl", CreateColumnHandle.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("\u52a0\u8f7d\u6570\u636e\u5e93\u5904\u7406\u5de5\u5382\u5931\u8d25\uff0c\u7a0b\u5e8f\u9519\u8bef!");
        }
    }
}

