/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.rdbms.in;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.data.Data;
import risesoft.data.transfer.core.data.StringData;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.record.DefaultRecord;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.stream.in.DataInputStream;
import risesoft.data.transfer.stream.rdbms.in.columns.CreateColumnHandle;
import risesoft.data.transfer.stream.rdbms.utils.DBUtil;

public class RdbmsDataInputStream
implements DataInputStream {
    private Connection connection;
    private String selectSql;
    private int fetchSize;
    private List<CreateColumnHandle> createColumnHandles;
    private String encoding;
    private Logger logger;

    public RdbmsDataInputStream(Connection connection, String selectSql, int fetchSize, List<CreateColumnHandle> createColumnHandles, String encoding, Logger logger) {
        this.connection = connection;
        this.selectSql = selectSql;
        this.fetchSize = fetchSize;
        this.createColumnHandles = createColumnHandles;
        this.encoding = encoding;
        this.logger = logger;
    }

    public void close() throws Exception {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger.debug((Object)this, "close input stream");
    }

    public void read(Data data, InChannel inChannel) {
        ResultSet resultSet;
        String sql = this.selectSql + ((StringData)data).getValue();
        if (this.logger.isDebug()) {
            this.logger.debug((Object)this, "work sql: " + sql);
        }
        try {
            resultSet = DBUtil.query(this.connection, sql, this.fetchSize);
        }
        catch (SQLException e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("sql \u6267\u884c\u62a5\u9519" + sql), (Throwable)e);
        }
        try {
            this.logger.debug((Object)this, "readData:");
            while (resultSet.next()) {
                ResultSetMetaData metaData = resultSet.getMetaData();
                DefaultRecord record = new DefaultRecord();
                try {
                    for (int i = 0; i < this.createColumnHandles.size(); ++i) {
                        CreateColumnHandle createColumnHandle = this.createColumnHandles.get(i);
                        record.addColumn(createColumnHandle.getColumn(resultSet, metaData, i + 1, this.encoding));
                    }
                    inChannel.writer((Record)record);
                }
                catch (Exception e) {
                    inChannel.collectDirtyRecord((Record)record, (Throwable)e, "\u810f\u6570\u636e" + e.getMessage());
                }
            }
            inChannel.flush();
            this.logger.debug((Object)this, "readData end");
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"\u8bfb\u53d6\u6570\u636e\u62a5\u9519", (Throwable)e);
        }
    }
}

