/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.ftp.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FtpUploadExample {
    public static void main(String[] args) {
        String server = "ftp.example.com";
        int port = 21;
        String user = "username";
        String pass = "password";
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient.connect(server, port);
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftpClient.disconnect();
                System.err.println("FTP server refused connection.");
                return;
            }
            ftpClient.login(user, pass);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            File localFile = new File("path/to/local/file.txt");
            FileInputStream inputStream = new FileInputStream(localFile);
            boolean success = ftpClient.storeFile("path/on/server/file.txt", (InputStream)inputStream);
            inputStream.close();
            if (success) {
                System.out.println("File has been uploaded successfully.");
            } else {
                System.out.println("Could not upload file.");
            }
            ftpClient.logout();
            ftpClient.disconnect();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            try {
                if (ftpClient.isConnected()) {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }
    }
}

