/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.ftp.out.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.net.ftp.FTPClient;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.record.Ack;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.stream.out.DataOutputStream;
import risesoft.data.transfer.core.stream.out.DataOutputStreamFactory;
import risesoft.data.transfer.stream.ftp.model.FTPFileInfoColumn;
import risesoft.data.transfer.stream.ftp.model.FTPInfo;
import risesoft.data.transfer.stream.ftp.out.local.LocalConfig;
import risesoft.data.transfer.stream.ftp.utils.FTPUtils;

public class FTPFileOutputLocalStreamFactory
implements DataOutputStreamFactory {
    private Logger logger;
    private LocalConfig localConfig;
    private Map<String, FTPClient> clientMap = new HashMap<String, FTPClient>();

    public FTPFileOutputLocalStreamFactory(LocalConfig localConfig, LoggerFactory loggerFactory) {
        this.logger = loggerFactory.getLogger(localConfig.getName());
        this.localConfig = localConfig;
        this.localConfig.setBufferSize(this.localConfig.getBufferSize() * 1024);
    }

    public void init() {
    }

    public DataOutputStream getStream() {
        return new DataOutputStream(){

            public void close() throws Exception {
            }

            public void writer(Record record, Ack ack) {
                try {
                    for (int i = 0; i < record.getColumnNumber(); ++i) {
                        Column column = record.getColumn(i);
                        if (!(column instanceof FTPFileInfoColumn)) continue;
                        FTPFileInfoColumn ftpFileInfoColumn = (FTPFileInfoColumn)column;
                        FTPClient ftpClient = FTPFileOutputLocalStreamFactory.this.getFTPClient(ftpFileInfoColumn.getFtpInfo());
                        String file = FTPFileOutputLocalStreamFactory.this.localConfig.getPath() + ftpFileInfoColumn.getFilePath();
                        FileUtils.forceMkdir((File)new File(file.substring(0, file.lastIndexOf("/") + 1)));
                        if (FTPFileOutputLocalStreamFactory.this.logger.isDebug()) {
                            FTPFileOutputLocalStreamFactory.this.logger.debug((Object)this, "transfer " + ftpFileInfoColumn.getFilePath() + " to " + file);
                        }
                        if (ftpClient.retrieveFile(ftpFileInfoColumn.getFilePath(), (OutputStream)new FileOutputStream(new File(file)))) continue;
                        throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)(ftpFileInfoColumn.getFilePath() + "\u6587\u4ef6\u4f20\u8f93\u5931\u8d25\u672a\u77e5\u539f\u56e0!\u76ee\u6807\u6587\u4ef6" + file));
                    }
                    ack.confirm(record);
                }
                catch (Exception e) {
                    ack.cancel(record, (Throwable)e, "\u4eceFTP \u8f93\u51fa\u6587\u4ef6\u5230\u672c\u5730\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
                }
            }

            public void writer(List<Record> records, Ack ack) {
                for (Record record : records) {
                    this.writer(record, ack);
                }
            }
        };
    }

    public synchronized void close() throws Exception {
        Set<String> keySet = this.clientMap.keySet();
        for (String key : keySet) {
            FTPClient ftpClient = this.clientMap.get(key);
            if (this.logger.isDebug()) {
                this.logger.debug((Object)this, "close ftp:" + key);
            }
            try {
                if (!ftpClient.isConnected()) continue;
                ftpClient.logout();
                ftpClient.disconnect();
            }
            catch (Exception e) {
                this.logger.error((Object)this, "\u5173\u95ed\u8fde\u63a5:" + key + "\u65f6\u51fa\u9519" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPClient getFTPClient(FTPInfo ftpInfo) {
        String key = ftpInfo.getHost() + ftpInfo.getPort() + ftpInfo.getUserName() + Thread.currentThread().getId();
        FTPClient ftpClient = this.clientMap.get(key);
        if (ftpClient == null) {
            Map<String, FTPClient> map = this.clientMap;
            synchronized (map) {
                ftpClient = this.clientMap.get(key);
                if (ftpClient == null) {
                    if (this.logger.isDebug()) {
                        this.logger.debug((Object)this, "login ftp " + ftpInfo.getHost() + ":" + ftpInfo.getPort() + "/" + ftpInfo.getUserName());
                    }
                    ftpClient = FTPUtils.getClient(ftpInfo.getHost(), ftpInfo.getPort(), ftpInfo.getUserName(), ftpInfo.getPassword(), "ISO-8859-1", ftpInfo.isActiveModel());
                    ftpClient.setBufferSize(this.localConfig.getBufferSize());
                    this.clientMap.put(key, ftpClient);
                }
            }
        }
        return ftpClient;
    }
}

