/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.ftp.in.stream;

import cn.hutool.core.date.DateUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.data.Data;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.record.DefaultRecord;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.stream.in.DataInputStream;
import risesoft.data.transfer.core.stream.in.DataInputStreamFactory;
import risesoft.data.transfer.stream.FileInfoColumn;
import risesoft.data.transfer.stream.Stream;
import risesoft.data.transfer.stream.ftp.in.info.FtpConfig;
import risesoft.data.transfer.stream.ftp.utils.FTPUtils;
import risesoft.data.transfer.stream.ftp.utils.PattenUtil;

public class FTPFileSyncInputStreamFactory
implements DataInputStreamFactory {
    private Logger logger;
    private FtpConfig ftpConfig;
    private String fileNameMatch;
    private long maxDate = -1L;

    public FTPFileSyncInputStreamFactory(FtpConfig ftpConfig, LoggerFactory loggerFactory) {
        this.ftpConfig = ftpConfig;
        this.logger = loggerFactory.getLogger(ftpConfig.getName());
    }

    public void init() {
        if (!StringUtils.isEmpty((CharSequence)this.ftpConfig.getDate())) {
            try {
                this.maxDate = DateUtil.parse((CharSequence)this.ftpConfig.getDate(), (String)"yyyy-MM-dd HH:mm:ss").getTime();
            }
            catch (Exception e) {
                throw new TransferException((ErrorCode)CommonErrorCode.CONFIG_ERROR, "\u65f6\u95f4\u683c\u5f0f\u5316\u9519\u8bef\u8bf7\u786e\u4fdd\u65f6\u95f4\u683c\u5f0f\u4e3ayyyy-MM-dd HH:mm:ss " + e.getMessage());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.ftpConfig.getFileName())) {
            this.fileNameMatch = this.ftpConfig.getFileName();
        }
    }

    public DataInputStream getStream() {
        return new FileSyncInputDataInputStream(this.ftpConfig);
    }

    public void close() throws Exception {
    }

    public List<Data> splitToData(int executorSize) throws Exception {
        return Arrays.asList(this.ftpConfig);
    }

    private FTPFile getFileByFullPath(FTPClient ftpClient, String path) throws IOException {
        FTPFile[] files;
        int pathIndex = path.lastIndexOf(47);
        if (pathIndex != -1) {
            ftpClient.changeWorkingDirectory(path.substring(0, pathIndex));
        }
        String fileName = path.substring(pathIndex + 1);
        for (FTPFile file : files = ftpClient.listFiles()) {
            if (!file.getName().equals(fileName)) continue;
            return file;
        }
        return null;
    }

    private void readFiles(FTPFile rootFile, FTPClient ftpClient, String rootPath, InChannel inChannel, long date, String fileNameMatch) throws IOException {
        if (rootFile == null) {
            FTPFile[] ftpFiles2;
            for (FTPFile ftpFile : ftpFiles2 = ftpClient.listFiles()) {
                this.readTreeFiles(ftpFile, ftpClient, rootPath, inChannel, date, fileNameMatch);
            }
        } else {
            this.readTreeFiles(rootFile, ftpClient, rootPath, inChannel, date, fileNameMatch);
        }
    }

    private void readTreeFiles(FTPFile rootFile, final FTPClient ftpClient, String rootPath, InChannel inChannel, long date, String fileNameMatch) throws IOException {
        if (rootFile.isDirectory()) {
            FTPFile[] ftpFiles2;
            rootPath = (String)(((String)rootPath).endsWith("/") ? rootPath : (String)rootPath + "/") + rootFile.getName();
            for (FTPFile ftpFile : ftpFiles2 = ftpClient.listFiles((String)rootPath)) {
                this.readTreeFiles(ftpFile, ftpClient, (String)rootPath, inChannel, date, fileNameMatch);
            }
        } else {
            if (date != -1L && rootFile.getTimestamp().getTimeInMillis() < date) {
                return;
            }
            if (fileNameMatch != null && !PattenUtil.hasMatch(fileNameMatch, rootFile.getName())) {
                return;
            }
            DefaultRecord defaultRecord = new DefaultRecord();
            String fileName = new String(rootFile.getName().getBytes(Charset.forName("ISO-8859-1")), "UTF-8");
            final String filePath = ((String)(((String)rootPath).endsWith("/") ? rootPath : (String)rootPath + "/") + "/" + fileName).replace("//", "/");
            defaultRecord.addColumn((Column)new FileInfoColumn(new Stream(){

                public void writer(OutputStream outputStream) {
                    try {
                        if (!ftpClient.retrieveFile(filePath, outputStream)) {
                            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)(filePath + "\u6587\u4ef6\u4f20\u8f93\u5931\u8d25,\u672a\u77e5\u539f\u56e0\uff0c\u53ef\u80fd\u662fFTP\u5df2\u7ecf\u65ad\u5f00"));
                        }
                    }
                    catch (IOException e) {
                        throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)(filePath + "\u6587\u4ef6\u4f20\u8f93\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f:" + e.getMessage()));
                    }
                }

                public byte[] getBytes() {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    this.writer(outputStream);
                    return outputStream.toByteArray();
                }
            }, rootFile.getSize(), fileNameMatch, filePath, rootFile.getTimestamp().getTimeInMillis()));
            inChannel.writer((Record)defaultRecord);
        }
    }

    class FileSyncInputDataInputStream
    implements DataInputStream {
        private FTPClient ftpClient;

        FileSyncInputDataInputStream(FtpConfig ftpConfig) {
            this.ftpClient = FTPUtils.getClient(ftpConfig.getHost(), ftpConfig.getPort(), ftpConfig.getUserName(), ftpConfig.getPassword(), ftpConfig.getEncoding(), ftpConfig.isActiveModel());
        }

        public void close() throws Exception {
            try {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
            catch (IOException e) {
                FTPFileSyncInputStreamFactory.this.logger.error((Object)this, "\u5173\u95edftp\u5ba2\u6237\u7aef\u51fa\u9519" + e.getMessage());
            }
        }

        public void read(Data data, InChannel inChannel) {
            FtpConfig ftpConfig = (FtpConfig)data;
            try {
                FTPFileSyncInputStreamFactory.this.logger.debug((Object)this, "login");
                FTPFile ftpFile = FTPFileSyncInputStreamFactory.this.getFileByFullPath(this.ftpClient, ftpConfig.getPath());
                try {
                    FTPFileSyncInputStreamFactory.this.readFiles(ftpFile, this.ftpClient, ftpConfig.getPath(), inChannel, FTPFileSyncInputStreamFactory.this.maxDate, FTPFileSyncInputStreamFactory.this.fileNameMatch);
                }
                catch (Exception e) {
                    throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("\u4eceftp\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u65f6\u51fa\u9519:" + e.getMessage()));
                }
                inChannel.flush();
            }
            catch (Throwable e) {
                throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)e.getMessage(), (Throwable)e);
            }
        }
    }
}

