/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.ftp.in.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import risesoft.data.transfer.core.data.Data;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.stream.in.DataInputStream;
import risesoft.data.transfer.core.stream.in.DataInputStreamFactory;
import risesoft.data.transfer.stream.ftp.in.stream.FTPFileInPutStream;
import risesoft.data.transfer.stream.ftp.in.stream.FtpConfig;
import risesoft.data.transfer.stream.ftp.utils.FTPUtils;

public class FTPFileInPutStreamFactory
implements DataInputStreamFactory {
    private Logger logger;
    private FtpConfig ftpConfig;

    public FTPFileInPutStreamFactory(FtpConfig ftpConfig, LoggerFactory loggerFactory) {
        this.ftpConfig = ftpConfig;
        ftpConfig.buffer = ftpConfig.buffer;
        this.logger = loggerFactory.getLogger(ftpConfig.name);
    }

    public void init() {
    }

    public DataInputStream getStream() {
        return new FTPFileInPutStream(FTPUtils.getClient(this.ftpConfig.host, this.ftpConfig.port, this.ftpConfig.userName, this.ftpConfig.password, this.ftpConfig.encoding, this.ftpConfig.isActiveModel()), this.logger, this.ftpConfig.buffer);
    }

    public void close() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Data> splitToData(int executorSize) throws Exception {
        FTPClient ftpClient = FTPUtils.getClient(this.ftpConfig.host, this.ftpConfig.port, this.ftpConfig.userName, this.ftpConfig.password, this.ftpConfig.encoding, this.ftpConfig.isActiveModel());
        try {
            this.logger.debug((Object)this, "login");
            FTPFile ftpFile = this.getFileByFullPath(ftpClient, this.ftpConfig.path);
            List<Data> ftpEntiries = null;
            try {
                ftpEntiries = this.getFiles(ftpFile, ftpClient, this.ftpConfig.path);
            }
            catch (Exception e) {
                throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("\u4eceftp\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u65f6\u51fa\u9519:" + e.getMessage()));
            }
            if (this.logger.isDebug()) {
                this.logger.debug((Object)this, "sub data " + ftpEntiries.size());
            }
            List<Data> list = ftpEntiries;
            return list;
        }
        finally {
            ftpClient.logout();
            ftpClient.disconnect();
        }
    }

    private FTPFile getFileByFullPath(FTPClient ftpClient, String path) throws IOException {
        FTPFile[] files;
        int pathIndex = path.lastIndexOf(47);
        if (pathIndex != -1) {
            ftpClient.changeWorkingDirectory(path.substring(0, pathIndex));
        }
        String fileName = path.substring(pathIndex + 1);
        for (FTPFile file : files = ftpClient.listFiles()) {
            if (!file.getName().equals(fileName)) continue;
            return file;
        }
        return null;
    }

    private List<FTPFileEntiry> getFiles(FTPFile rootFile, FTPClient ftpClient, String rootPath) throws IOException {
        ArrayList<FTPFileEntiry> ftpFiles = new ArrayList<FTPFileEntiry>();
        if (rootFile == null) {
            FTPFile[] ftpFiles2;
            for (FTPFile ftpFile : ftpFiles2 = ftpClient.listFiles()) {
                this.getFiles(ftpFile, ftpFiles, ftpClient, rootPath);
            }
        } else {
            this.getFiles(rootFile, ftpFiles, ftpClient, rootPath);
        }
        return ftpFiles;
    }

    private void getFiles(FTPFile rootFile, List<FTPFileEntiry> ftpFiles, FTPClient ftpClient, String rootPath) throws IOException {
        if (rootFile.isDirectory()) {
            FTPFile[] ftpFiles2;
            rootPath = (String)rootPath + "/" + rootFile.getName();
            for (FTPFile ftpFile : ftpFiles2 = ftpClient.listFiles((String)rootPath)) {
                this.getFiles(ftpFile, ftpFiles, ftpClient, (String)rootPath);
            }
        } else {
            ftpFiles.add(new FTPFileEntiry((String)rootPath + "/" + rootFile.getName(), rootFile));
        }
    }

    public static class FTPFileEntiry
    implements Data {
        private String absPath;
        private FTPFile ftpFile;

        public FTPFileEntiry(String absPath, FTPFile ftpFile) {
            this.absPath = absPath;
            this.ftpFile = ftpFile;
        }

        public String getAbsPath() {
            return this.absPath;
        }

        public FTPFile getFtpFile() {
            return this.ftpFile;
        }
    }
}

