/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.ftp.in.stream;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.data.Data;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.record.DefaultRecord;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.stream.in.DataInputStream;
import risesoft.data.transfer.stream.StreamColumn;
import risesoft.data.transfer.stream.ftp.in.stream.FTPFileInPutStreamFactory;

public class FTPFileInPutStream
implements DataInputStream {
    private FTPClient ftpClient;
    private Logger logger;
    private int bufferSize;

    public FTPFileInPutStream(FTPClient ftpClient, Logger logger, int bufferSize) {
        this.ftpClient = ftpClient;
        this.logger = logger;
        this.bufferSize = bufferSize;
    }

    public void close() throws Exception {
        this.ftpClient.logout();
        this.ftpClient.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Data data, InChannel inChannel) {
        FTPFileInPutStreamFactory.FTPFileEntiry ftpEntiry = (FTPFileInPutStreamFactory.FTPFileEntiry)data;
        DefaultRecord defaultRecord = null;
        try {
            InputStream inputStream = this.ftpClient.retrieveFileStream(ftpEntiry.getAbsPath());
            byte[] datas = new byte[this.bufferSize];
            int size = -1;
            int start = 0;
            int end = 0;
            int readSize = 0;
            boolean c = false;
            while ((size = inputStream.read(datas)) != -1) {
                defaultRecord = new DefaultRecord();
                readSize += size;
                defaultRecord.addColumn((Column)new StreamColumn(datas, size, ftpEntiry.getAbsPath(), start, end += size, ftpEntiry.getFtpFile().getSize()));
                inChannel.writer((Record)defaultRecord);
                datas = new byte[this.bufferSize];
                start = end;
            }
            defaultRecord = null;
            inputStream.close();
            this.ftpClient.disconnect();
            this.ftpClient.logout();
        }
        catch (IOException e) {
            if (defaultRecord != null) {
                inChannel.collectDirtyRecord(defaultRecord, (Throwable)e, e.getMessage());
            }
        }
        finally {
            inChannel.flush();
        }
    }
}

