/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.ftp.in.info;

import cn.hutool.core.date.DateUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.data.Data;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.record.DefaultRecord;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.stream.in.DataInputStream;
import risesoft.data.transfer.core.stream.in.DataInputStreamFactory;
import risesoft.data.transfer.stream.ftp.in.info.FtpConfig;
import risesoft.data.transfer.stream.ftp.model.FTPFileInfoColumn;
import risesoft.data.transfer.stream.ftp.utils.FTPUtils;
import risesoft.data.transfer.stream.ftp.utils.PattenUtil;

public class FTPFileInfoStreamFactory
implements DataInputStreamFactory,
DataInputStream {
    private Logger logger;
    private FtpConfig ftpConfig;
    private String fileNameMatch;
    private long maxDate = -1L;

    public FTPFileInfoStreamFactory(FtpConfig ftpConfig, LoggerFactory loggerFactory) {
        this.ftpConfig = ftpConfig;
        this.logger = loggerFactory.getLogger(ftpConfig.getName());
    }

    public void init() {
        if (!StringUtils.isEmpty((CharSequence)this.ftpConfig.getDate())) {
            try {
                this.maxDate = DateUtil.parse((CharSequence)this.ftpConfig.getDate(), (String)"yyyy-MM-dd HH:mm:ss").getTime();
            }
            catch (Exception e) {
                throw new TransferException((ErrorCode)CommonErrorCode.CONFIG_ERROR, "\u65f6\u95f4\u683c\u5f0f\u5316\u9519\u8bef\u8bf7\u786e\u4fdd\u65f6\u95f4\u683c\u5f0f\u4e3ayyyy-MM-dd HH:mm:ss " + e.getMessage());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.ftpConfig.getFileName())) {
            this.fileNameMatch = this.ftpConfig.getFileName();
        }
    }

    public DataInputStream getStream() {
        return this;
    }

    public void close() throws Exception {
    }

    public List<Data> splitToData(int executorSize) throws Exception {
        return Arrays.asList(this.ftpConfig);
    }

    private FTPFile getFileByFullPath(FTPClient ftpClient, String path) throws IOException {
        FTPFile[] files;
        int pathIndex = path.lastIndexOf(47);
        if (pathIndex != -1) {
            ftpClient.changeWorkingDirectory(path.substring(0, pathIndex));
        }
        String fileName = path.substring(pathIndex + 1);
        for (FTPFile file : files = ftpClient.listFiles()) {
            if (!file.getName().equals(fileName)) continue;
            return file;
        }
        return null;
    }

    private void readFiles(FTPFile rootFile, FTPClient ftpClient, String rootPath, InChannel inChannel, long date, String fileNameMatch) throws IOException {
        if (rootFile == null) {
            FTPFile[] ftpFiles2;
            for (FTPFile ftpFile : ftpFiles2 = ftpClient.listFiles()) {
                this.readTreeFiles(ftpFile, ftpClient, rootPath, inChannel, date, fileNameMatch);
            }
        } else {
            this.readTreeFiles(rootFile, ftpClient, rootPath, inChannel, date, fileNameMatch);
        }
    }

    private void readTreeFiles(FTPFile rootFile, FTPClient ftpClient, String rootPath, InChannel inChannel, long date, String fileNameMatch) throws IOException {
        if (rootFile.isDirectory()) {
            FTPFile[] ftpFiles2;
            rootPath = (String)(((String)rootPath).endsWith("/") ? rootPath : (String)rootPath + "/") + rootFile.getName();
            for (FTPFile ftpFile : ftpFiles2 = ftpClient.listFiles((String)rootPath)) {
                this.readTreeFiles(ftpFile, ftpClient, (String)rootPath, inChannel, date, fileNameMatch);
            }
        } else {
            if (date != -1L && rootFile.getTimestamp().getTimeInMillis() < date) {
                return;
            }
            if (fileNameMatch != null && !PattenUtil.hasMatch(fileNameMatch, rootFile.getName())) {
                return;
            }
            DefaultRecord defaultRecord = new DefaultRecord();
            String fileName = new String(rootFile.getName().getBytes(Charset.forName("ISO-8859-1")), "UTF-8");
            defaultRecord.addColumn((Column)new FTPFileInfoColumn(((String)(((String)rootPath).endsWith("/") ? rootPath : (String)rootPath + "/") + "/" + fileName).replace("//", "/"), Column.Type.STREAM, rootFile.getSize(), fileName, this.ftpConfig));
            inChannel.writer((Record)defaultRecord);
        }
    }

    public void read(Data data, InChannel inChannel) {
        FtpConfig ftpConfig = (FtpConfig)data;
        FTPClient ftpClient = FTPUtils.getClient(ftpConfig.getHost(), ftpConfig.getPort(), ftpConfig.getUserName(), ftpConfig.getPassword(), ftpConfig.getEncoding());
        try {
            this.logger.debug((Object)this, "login");
            FTPFile ftpFile = this.getFileByFullPath(ftpClient, ftpConfig.getPath());
            try {
                this.readFiles(ftpFile, ftpClient, ftpConfig.getPath(), inChannel, this.maxDate, this.fileNameMatch);
            }
            catch (Exception e) {
                throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("\u4eceftp\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u65f6\u51fa\u9519:" + e.getMessage()));
            }
            inChannel.flush();
        }
        catch (Throwable e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                ftpClient.logout();
                ftpClient.disconnect();
            }
            catch (IOException e) {
                this.logger.error((Object)this, "\u5173\u95edftp\u5ba2\u6237\u7aef\u51fa\u9519" + e.getMessage());
            }
        }
    }
}

