/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.es.out;

import java.util.List;
import net.risesoft.elastic.client.ElasticsearchRestClient;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.stream.out.DataOutputStream;
import risesoft.data.transfer.core.stream.out.DataOutputStreamFactory;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.core.util.ValueUtils;
import risesoft.data.transfer.stream.es.out.ElasticsearchOutputStream;

public class ElasticsearchOutputStreamFactory
implements DataOutputStreamFactory {
    private String url;
    private String username;
    private String password;
    private String indexName;
    private List<String> columns;
    private String writerType;
    private Logger logger;
    private ElasticsearchRestClient elasticsearchRestClient;

    public ElasticsearchOutputStreamFactory(Configuration configuration, JobContext jobContext) {
        this.url = (String)ValueUtils.getRequired((Object)configuration.getString("jdbcUrl"), (String)"\u7f3a\u5931\u8fde\u63a5\u5730\u5740");
        this.password = configuration.getString("password", "");
        this.username = configuration.getString("userName", "");
        this.indexName = (String)ValueUtils.getRequired((Object)configuration.getString("tableName"), (String)"\u7f3a\u5931\u7d22\u5f15\u8868\u540d\u79f0");
        this.columns = (List)ValueUtils.getRequired((Object)configuration.getList("column", String.class), (String)"\u7f3a\u5931\u5b57\u6bb5\u5217\u8868");
        this.writerType = configuration.getString("writerType", "insert");
        this.logger = jobContext.getLoggerFactory().getLogger(ElasticsearchOutputStreamFactory.class);
        this.elasticsearchRestClient = new ElasticsearchRestClient(this.url, this.username, this.password);
    }

    public void init() {
    }

    public void close() throws Exception {
    }

    public DataOutputStream getStream() {
        return new ElasticsearchOutputStream(this.elasticsearchRestClient, this.indexName, this.columns, this.writerType, this.logger);
    }
}

