/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.es.out;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risesoft.elastic.client.ElasticsearchRestClient;
import net.risesoft.y9.json.Y9JsonUtil;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.record.Ack;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.stream.out.DataOutputStream;

public class ElasticsearchOutputStream
implements DataOutputStream {
    private ElasticsearchRestClient elasticsearchRestClient;
    private String indexName;
    private List<String> columns;
    private String writerType;
    private Logger logger;

    public ElasticsearchOutputStream(ElasticsearchRestClient elasticsearchRestClient, String indexName, List<String> columns, String writerType, Logger logger) {
        this.elasticsearchRestClient = elasticsearchRestClient;
        this.indexName = indexName;
        this.columns = columns;
        this.writerType = writerType;
        this.logger = logger;
    }

    public void close() throws Exception {
    }

    public void writer(List<Record> records, Ack ack) {
        try {
            this.logger.debug((Object)this, "plan writer: " + records.size());
            for (Record record : records) {
                try {
                    String id = "";
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    Map<String, Column> recordMap = this.getRecordMap(record);
                    for (String name : this.columns) {
                        Column column = recordMap.get(name);
                        if (column == null) continue;
                        if (name.equals("id")) {
                            id = String.valueOf(column.getRawData());
                        }
                        data.put(name, column.getRawData());
                    }
                    this.elasticsearchRestClient.addDocument(this.indexName, Y9JsonUtil.writeValueAsString(data), id);
                    ack.confirm(record);
                }
                catch (Exception e) {
                    this.logger.error((Object)this, record + " error:" + e.getMessage());
                    ack.cancel(record, (Throwable)e, e.toString());
                }
            }
            if (this.logger.isDebug()) {
                this.logger.debug((Object)this, "confirm end: " + records.size());
            }
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"\u6267\u884c\u63d2\u5165\u62a5\u9519", (Throwable)e);
        }
    }

    private Map<String, Column> getRecordMap(Record record) {
        HashMap<String, Column> recordMap = new HashMap<String, Column>();
        for (int i = 0; i < record.getColumnNumber(); ++i) {
            recordMap.put(record.getColumn(i).getName(), record.getColumn(i));
        }
        return recordMap;
    }

    public void writer(Record record, Ack ack) {
        try {
            String id = "";
            HashMap<String, Object> data = new HashMap<String, Object>();
            Map<String, Column> recordMap = this.getRecordMap(record);
            for (String name : this.columns) {
                Column column = recordMap.get(name);
                if (column == null) continue;
                if (name.equals("id")) {
                    id = String.valueOf(column.getRawData());
                }
                data.put(name, column.getRawData());
            }
            this.elasticsearchRestClient.addDocument(this.indexName, Y9JsonUtil.writeValueAsString(data), id);
            ack.confirm(record);
        }
        catch (Exception e) {
            e.printStackTrace();
            ack.cancel(record, (Throwable)e, e.getMessage());
        }
    }
}

