/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.es.in;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risesoft.elastic.client.ElasticsearchRestClient;
import net.risesoft.elastic.client.pojo.QueryModel;
import net.risesoft.y9.json.Y9JsonUtil;
import org.apache.commons.lang3.StringUtils;
import risesoft.data.transfer.core.data.Data;
import risesoft.data.transfer.core.data.StringData;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.FrameworkErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.log.LoggerFactory;
import risesoft.data.transfer.core.stream.in.DataInputStream;
import risesoft.data.transfer.core.stream.in.DataInputStreamFactory;
import risesoft.data.transfer.core.util.Configuration;
import risesoft.data.transfer.core.util.ValueUtils;
import risesoft.data.transfer.stream.es.in.ElasticsearchInputStream;

public class ElasticsearchInputStreamFactory
implements DataInputStreamFactory {
    private ElasticsearchRestClient elasticsearchRestClient;
    private Logger logger;
    private String url;
    private String username;
    private String password;
    private String indexName;
    private List<String> columns;
    private String query;
    private String splitPk;
    private Boolean precise;
    private Integer tableNumber;
    private Integer splitFactor;
    private Map<String, String> columnTypes;

    public ElasticsearchInputStreamFactory(Configuration configuration, LoggerFactory loggerFactory) {
        this.url = (String)ValueUtils.getRequired((Object)configuration.getString("jdbcUrl"), (String)"\u7f3a\u5931\u8fde\u63a5\u5730\u5740");
        this.password = configuration.getString("password", "");
        this.username = configuration.getString("userName", "");
        this.indexName = (String)ValueUtils.getRequired((Object)configuration.getString("tableName"), (String)"\u7f3a\u5931\u7d22\u5f15\u8868\u540d\u79f0");
        this.columns = (List)ValueUtils.getRequired((Object)configuration.getList("column", String.class), (String)"\u7f3a\u5931\u5b57\u6bb5\u5217\u8868");
        this.query = configuration.getString("where", "").trim();
        this.splitPk = configuration.getString("splitPk");
        this.precise = configuration.getBool("precise", false);
        this.splitFactor = configuration.getInt("splitFactor", -1);
        this.tableNumber = configuration.getInt("tableNumber", -1);
        this.logger = loggerFactory.getLogger(configuration.getString("name", "ElasticsearchInputStreamFactory"));
        this.elasticsearchRestClient = new ElasticsearchRestClient(this.url, this.username, this.password);
    }

    public DataInputStream getStream() {
        return new ElasticsearchInputStream(this.elasticsearchRestClient, this.indexName, this.columnTypes, this.logger);
    }

    public void init() {
        block4: {
            this.columnTypes = new HashMap<String, String>();
            try {
                String data = this.elasticsearchRestClient.getMapping(this.indexName);
                if (!data.equals("failed")) {
                    HashMap map = Y9JsonUtil.readHashMap((String)data);
                    Map mappings = (Map)map.get(this.indexName);
                    Map properties = (Map)mappings.get("mappings");
                    Map dataMap = (Map)properties.get("properties");
                    for (Map.Entry entry : dataMap.entrySet()) {
                        String column_name = (String)entry.getKey();
                        Map value = (Map)entry.getValue();
                        this.columnTypes.put(column_name, (String)value.get("type"));
                    }
                    break block4;
                }
                throw TransferException.as((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, (String)"\u521d\u59cb\u5316ES\u8f93\u5165\u6d41\u5de5\u5382\u5931\u8d25\uff1a\u83b7\u53d6\u7d22\u5f15\u8868\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25");
            }
            catch (Exception e) {
                throw TransferException.as((ErrorCode)FrameworkErrorCode.RUNTIME_ERROR, (String)("\u521d\u59cb\u5316ES\u8f93\u5165\u6d41\u5de5\u5382\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void close() throws Exception {
    }

    public List<Data> splitToData(int executorSize) throws Exception {
        boolean isSub;
        ArrayList<Data> querys = null;
        int count = 0;
        try {
            count = this.elasticsearchRestClient.getCount(this.indexName);
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"elastic\u6570\u91cf\u67e5\u8be2-\u6267\u884c\u62a5\u9519", (Throwable)e);
        }
        int numberSize = this.tableNumber != -1 ? this.tableNumber : (this.splitFactor != -1 ? executorSize * this.splitFactor : 1);
        boolean bl = isSub = numberSize >= 1 && StringUtils.isNotEmpty((CharSequence)this.splitPk);
        if (isSub) {
            if (this.logger.isInfo()) {
                this.logger.info((Object)this, "sub data to " + numberSize);
            }
            QueryModel queryModel = null;
            if (this.precise.booleanValue()) {
                querys = new ArrayList();
                List<Map<String, Object>> groupData = this.getGroupData();
                for (Map<String, Object> data : groupData) {
                    String key = String.valueOf(data.get("key"));
                    Integer doc_count = (Integer)data.get("doc_count");
                    queryModel = new QueryModel();
                    queryModel.set_source(QueryModel.get_source(this.columns));
                    if (StringUtils.isNotBlank((CharSequence)this.query)) {
                        ArrayList<HashMap> listMap = new ArrayList<HashMap>();
                        listMap.add(Y9JsonUtil.readHashMap((String)this.query));
                        listMap.add(Y9JsonUtil.readHashMap((String)QueryModel.get_query((String)this.splitPk, (String)key, (String)"term")));
                        queryModel.setQuery(QueryModel.get_boolMustQuery(listMap));
                    } else {
                        queryModel.setQuery(QueryModel.get_query((String)this.splitPk, (String)key, (String)"term"));
                    }
                    queryModel.setSize(doc_count);
                    querys.add((Data)new StringData(Y9JsonUtil.writeValueAsString((Object)queryModel)));
                }
            } else {
                querys = new ArrayList();
                List<Map<String, Integer>> parts = this.splitDataIntoParts(count, numberSize);
                for (Map<String, Integer> map : parts) {
                    queryModel = new QueryModel();
                    queryModel.set_source(QueryModel.get_source(this.columns));
                    if (StringUtils.isNotBlank((CharSequence)this.query)) {
                        queryModel.setQuery(this.query);
                    }
                    queryModel.setSort("{\"" + this.splitPk + "\":{\"order\":\"asc\"}}");
                    queryModel.setFrom(map.get("from"));
                    queryModel.setSize(map.get("size"));
                    querys.add((Data)new StringData(Y9JsonUtil.writeValueAsString((Object)queryModel)));
                }
            }
            if (this.logger.isInfo()) {
                this.logger.info((Object)this, "sub data end: " + querys.size());
            }
        } else {
            if (count > 10000) {
                throw new TransferException((ErrorCode)CommonErrorCode.WAIT_TIME_EXCEED, "\u6570\u636e\u8fc7\u5927\uff0c\u5efa\u8bae\u4f7f\u7528\u5207\u5206\u6a21\u5f0f");
            }
            this.logger.info((Object)this, "no sub data");
            querys = new ArrayList<Data>();
            QueryModel queryModel = new QueryModel();
            queryModel.set_source(QueryModel.get_source(this.columns));
            if (StringUtils.isNotBlank((CharSequence)this.query)) {
                queryModel.setQuery(this.query);
            }
            queryModel.setSize(Integer.valueOf(count));
            querys.add((Data)new StringData(Y9JsonUtil.writeValueAsString((Object)queryModel)));
        }
        return querys;
    }

    private List<Map<String, Integer>> splitDataIntoParts(int count, int parts) {
        if (count <= 0) {
            throw new TransferException((ErrorCode)CommonErrorCode.CONFIG_ERROR, "\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5207\u5206");
        }
        ArrayList<Map<String, Integer>> listMap = new ArrayList<Map<String, Integer>>();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int chunkSize = count / parts;
        int remainder = count % parts;
        for (int i = 0; i < parts; ++i) {
            int end;
            int start = i * chunkSize;
            int n = end = i == parts - 1 ? count : start + chunkSize;
            if (remainder > 0) {
                ++end;
                --remainder;
            }
            result.put("from", start);
            result.put("size", end);
            listMap.add(result);
        }
        return listMap;
    }

    private List<Map<String, Object>> getGroupData() {
        QueryModel queryModel = new QueryModel();
        queryModel.setAggs("{\"aggs_name\":{\"terms\":{\"field\":\"" + this.splitPk + "\", \"size\":100}}}");
        if (StringUtils.isNotBlank((CharSequence)this.query)) {
            queryModel.setQuery(this.query);
        }
        try {
            Map map = this.elasticsearchRestClient.search(queryModel, this.indexName);
            return (List)map.get("data");
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"elastic\u5206\u7ec4\u67e5\u8be2-\u6267\u884c\u62a5\u9519", (Throwable)e);
        }
    }
}

