/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.stream.es.in;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.risesoft.elastic.client.ElasticsearchRestClient;
import net.risesoft.elastic.client.pojo.QueryModel;
import net.risesoft.y9.json.Y9JsonUtil;
import risesoft.data.transfer.core.channel.InChannel;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.column.impl.BoolColumn;
import risesoft.data.transfer.core.column.impl.DateColumn;
import risesoft.data.transfer.core.column.impl.DoubleColumn;
import risesoft.data.transfer.core.column.impl.LongColumn;
import risesoft.data.transfer.core.column.impl.StringColumn;
import risesoft.data.transfer.core.data.Data;
import risesoft.data.transfer.core.data.StringData;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.log.Logger;
import risesoft.data.transfer.core.record.DefaultRecord;
import risesoft.data.transfer.core.record.Record;
import risesoft.data.transfer.core.stream.in.DataInputStream;

public class ElasticsearchInputStream
implements DataInputStream {
    private ElasticsearchRestClient elasticsearchRestClient;
    private String indexName;
    private Map<String, String> columnTypes;
    private Logger logger;

    public ElasticsearchInputStream(ElasticsearchRestClient elasticsearchRestClient, String indexName, Map<String, String> columnTypes, Logger logger) {
        this.elasticsearchRestClient = elasticsearchRestClient;
        this.indexName = indexName;
        this.columnTypes = columnTypes;
        this.logger = logger;
    }

    public void close() throws Exception {
    }

    public void read(Data data, InChannel inChannel) {
        Map dataMap = null;
        QueryModel queryModel = (QueryModel)Y9JsonUtil.readValue((String)((StringData)data).getValue(), QueryModel.class);
        try {
            dataMap = this.elasticsearchRestClient.search(queryModel, this.indexName);
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"elastic\u67e5\u8be2-\u6267\u884c\u62a5\u9519", (Throwable)e);
        }
        try {
            this.logger.debug((Object)this, "readData start");
            List listMap = (List)dataMap.get("data");
            for (Map map : listMap) {
                DefaultRecord record = new DefaultRecord();
                try {
                    for (Map.Entry entry : map.entrySet()) {
                        String column_name = (String)entry.getKey();
                        String type = this.columnTypes.get(column_name);
                        record.addColumn(this.getColumn(type, String.valueOf(entry.getValue()), column_name));
                    }
                    inChannel.writer((Record)record);
                }
                catch (Exception e) {
                    inChannel.collectDirtyRecord((Record)record, (Throwable)e, "\u810f\u6570\u636e" + e.getMessage());
                }
            }
            inChannel.flush();
            this.logger.debug((Object)this, "readData end");
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"\u8bfb\u53d6\u6570\u636e\u62a5\u9519", (Throwable)e);
        }
    }

    private Column getColumn(String type, String data, String name) {
        switch (type) {
            case "keyword": 
            case "text": {
                return new StringColumn(data, name);
            }
            case "long": 
            case "integer": 
            case "short": {
                return new LongColumn(data, name);
            }
            case "double": 
            case "float": {
                return new DoubleColumn(data, name);
            }
            case "boolean": {
                return new BoolColumn(data, name);
            }
            case "date": {
                return new DateColumn(this.getDate(data), name);
            }
        }
        return new StringColumn(data, name);
    }

    private Date getDate(String data) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (data.indexOf(":") > -1) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        try {
            return sdf.parse(data);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

