/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.plug.data.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import risesoft.data.transfer.plug.data.utils.Format;

public class DateUtils {
    private static final Map<String, ThreadLocal<SimpleDateFormat>> FORMATTERS = new HashMap<String, ThreadLocal<SimpleDateFormat>>();
    private static final Map<String, Pattern> PATTERNS = new HashMap<String, Pattern>();
    private static final Map<String, Format<List<String>>> PATTERN_FORMATS = new HashMap<String, Format<List<String>>>();
    private static final Map<String, String> FORMAT_MAP = new HashMap<String, String>();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("[YyMmDdSsHhWwEFZz]{1,4}");
    private static Object LOCK = new Object();
    private static Object PATTERN_LOCK = new Object();

    public static String format(Date date, String pattern) {
        return DateUtils.getFormat(pattern).format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleDateFormat getFormat(final String pattern) {
        ThreadLocal<SimpleDateFormat> df = FORMATTERS.get(pattern);
        if (df == null) {
            Object object = LOCK;
            synchronized (object) {
                df = FORMATTERS.get(pattern);
                if (df == null) {
                    df = new ThreadLocal<SimpleDateFormat>(){

                        @Override
                        protected SimpleDateFormat initialValue() {
                            return new SimpleDateFormat(pattern);
                        }
                    };
                    FORMATTERS.put(pattern, df);
                }
            }
        }
        return df.get();
    }

    public static Date parse(String text, String pattern) throws ParseException {
        return DateUtils.getFormat(pattern).parse(text);
    }

    public static Date parse(String source) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return null;
        }
        Set<String> keys = PATTERN_FORMATS.keySet();
        int differ = 0;
        for (String key : keys) {
            Pattern p;
            Matcher math;
            Format<List<String>> format = PATTERN_FORMATS.get(key);
            differ = format.getLength() - source.length();
            if (differ >= 3 || differ <= -3 || !(math = (p = PATTERNS.get(format.getFormat())).matcher(source)).find()) continue;
            List<String> list = format.getPattern();
            for (String formater : list) {
                try {
                    return DateUtils.parse(source, formater);
                }
                catch (ParseException parseException) {
                }
            }
        }
        throw new RuntimeException(source + " cannot parse");
    }

    public static void addFormat(String format) {
        DateUtils.getPattern(format);
    }

    public static void addDefaultFormat() {
        DateUtils.addFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
        DateUtils.addFormat("yyyy/MM/dd HH:mm");
        DateUtils.addFormat("yyyy/MM/d");
        DateUtils.addFormat("yyyy/M/d HH:mm");
        DateUtils.addFormat("yyyy-MM-dd HH:mm:ss");
        DateUtils.addFormat("yyyy\u5e74MM\u6708dd\u65e5");
        DateUtils.addFormat("yyyy-MM-dd");
        DateUtils.addFormat("yyyy.MM");
        DateUtils.addFormat("yyyy.M.dd");
        DateUtils.addFormat("yyyy.MM.d");
        DateUtils.addFormat("yyyy.MM.dd");
        DateUtils.addFormat("yyyy\u5e74MM\u6708");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPattern(String format) {
        Format<List<String>> format2;
        String pattern = FORMAT_MAP.get(format);
        if (pattern != null) {
            return pattern;
        }
        Matcher m = FORMAT_PATTERN.matcher(format);
        String temp = null;
        StringBuilder newexpression = new StringBuilder(format);
        int differ = 0;
        String newtemp = null;
        while (m.find()) {
            temp = m.group();
            newtemp = "\\d{1," + temp.length() + "}";
            newexpression = newexpression.replace(m.start() + differ, m.end() + differ, newtemp);
            differ += newtemp.length() - temp.length();
        }
        String patternStr = "(" + newexpression.toString() + ")";
        Format<List<String>> formats = PATTERN_FORMATS.get(patternStr);
        if (formats == null) {
            format2 = PATTERN_LOCK;
            synchronized (format2) {
                formats = PATTERN_FORMATS.get(patternStr);
                if (formats == null) {
                    formats = new Format();
                    formats.setFormat(patternStr);
                    formats.setLength(format.length());
                    PATTERN_FORMATS.put(patternStr, formats);
                    if (!PATTERNS.containsKey(patternStr)) {
                        PATTERNS.put(patternStr, Pattern.compile(patternStr));
                    }
                }
            }
        }
        format2 = formats;
        synchronized (format2) {
            List<String> formatchilds = formats.getPattern();
            if (formatchilds == null) {
                formatchilds = new ArrayList<String>();
                formats.setPattern(formatchilds);
            }
            formatchilds.add(format);
        }
        return patternStr;
    }

    public static Date updateDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    static {
        DateUtils.addDefaultFormat();
    }
}

