/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.plug.data.encrypt;

import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.column.impl.StringColumn;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.factory.annotations.ConfigParameter;
import risesoft.data.transfer.core.plug.Plug;
import risesoft.data.transfer.core.record.ColumnDisposeHandlePlug;

public class AESEncryptPlug
implements Plug {
    private Cipher cipher;

    public AESEncryptPlug(@ConfigParameter(required=true, description="\u5bc6\u94a5") String key, @ConfigParameter(required=true, description="\u5217\u540d") String field, JobContext jobContext) {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(key.getBytes("UTF-8"));
            keygen.init(128, secureRandom);
            SecretKey deskey = keygen.generateKey();
            this.cipher = Cipher.getInstance("AES");
            this.cipher.init(1, deskey);
        }
        catch (Exception e) {
            throw TransferException.as((ErrorCode)CommonErrorCode.CONFIG_ERROR, (String)("\u521b\u5efa\u52a0\u5bc6\u5bf9\u8c61\u5931\u8d25!" + e.getMessage()));
        }
        ColumnDisposeHandlePlug.registerListener((String)field, (c, r, i) -> {
            try {
                StringColumn column = new StringColumn(Base64.getEncoder().encodeToString(this.cipher.doFinal(c.asString().getBytes("UTF-8"))), c.getName());
                r.setColumn(i, (Column)column);
                return column;
            }
            catch (Exception e) {
                throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("\u5bf9\u79f0\u52a0\u5bc6AES\u5931\u8d25:" + e.getMessage()));
            }
        }, (JobContext)jobContext);
    }

    public boolean register(JobContext jobContext) {
        return true;
    }
}

