/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.plug.data.format;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.column.impl.DateColumn;
import risesoft.data.transfer.core.column.impl.StringColumn;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.factory.annotations.ConfigParameter;
import risesoft.data.transfer.core.plug.Plug;
import risesoft.data.transfer.core.record.ColumnDisposeHandlePlug;
import risesoft.data.transfer.plug.data.utils.DateUtils;

public class DateFormatPlug
implements Plug {
    public DateFormatPlug(@ConfigParameter(required=false, description="\u683c\u5f0f") String format, @ConfigParameter(required=true, description="\u5217\u540d") String field, JobContext jobContext) {
        boolean bool = StringUtils.isNotBlank((CharSequence)format);
        ColumnDisposeHandlePlug.registerListener((String)field, (c, r, i) -> {
            try {
                if (c.getType() == Column.Type.DATE) {
                    Date date = c.asDate();
                    if (date != null) {
                        if (!bool) {
                            throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)"\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25\uff0cdate\u5b57\u6bb5\u7c7b\u578b\u65f6format\u683c\u5f0f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        StringColumn column = new StringColumn(DateUtils.format(date, format), c.getName());
                        r.setColumn(i, (Column)column);
                        return column;
                    }
                } else {
                    String dateStr = c.asString();
                    if (!StringUtils.isEmpty((CharSequence)dateStr)) {
                        DateColumn column = bool ? new DateColumn(DateUtils.parse(dateStr, format), c.getName()) : new DateColumn(DateUtils.parse(dateStr), c.getName());
                        r.setColumn(i, (Column)column);
                        return column;
                    }
                }
                return c;
            }
            catch (Exception e) {
                throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25!:" + e.getMessage()), (Throwable)e);
            }
        }, (JobContext)jobContext);
    }

    public boolean register(JobContext jobContext) {
        return true;
    }
}

