/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.plug.data.desensitization;

import java.util.List;
import risesoft.data.transfer.core.column.Column;
import risesoft.data.transfer.core.column.impl.StringColumn;
import risesoft.data.transfer.core.context.JobContext;
import risesoft.data.transfer.core.exception.CommonErrorCode;
import risesoft.data.transfer.core.exception.ErrorCode;
import risesoft.data.transfer.core.exception.TransferException;
import risesoft.data.transfer.core.factory.annotations.ConfigParameter;
import risesoft.data.transfer.core.plug.Plug;
import risesoft.data.transfer.core.record.ColumnDisposeHandlePlug;
import risesoft.data.transfer.plug.data.desensitization.DesensitizationUtils;

public class DesensitizationPlug
implements Plug {
    public DesensitizationPlug(@ConfigParameter(required=true, description="\u8131\u654f\u5b57\u6bb5") List<String> desensitizationFields, JobContext jobContext) {
        for (String field : desensitizationFields) {
            ColumnDisposeHandlePlug.registerListener((String)field, (column, record, index) -> {
                try {
                    StringColumn newColumn = new StringColumn(DesensitizationUtils.desensitization(column.asString()), column.getName());
                    record.setColumn(index, (Column)newColumn);
                    return newColumn;
                }
                catch (Exception e) {
                    throw TransferException.as((ErrorCode)CommonErrorCode.RUNTIME_ERROR, (String)("\u5728\u6570\u636e\u8131\u654f\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage()));
                }
            }, (JobContext)jobContext);
        }
    }

    public boolean register(JobContext jobContext) {
        return true;
    }
}

