/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.util.pool;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import risesoft.data.transfer.core.util.pool.ObjectPool;

public class SyncObjectPool<T>
implements ObjectPool<T> {
    private BlockingQueue<T> queue;
    private volatile int size;
    private int maxSize;
    private Callable<T> createT;

    public SyncObjectPool(int maxSize, Callable<T> createT) {
        this.queue = new LinkedBlockingQueue<T>(maxSize);
        this.size = 0;
        this.maxSize = maxSize;
        this.createT = createT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getInstance() {
        Object ret = this.queue.poll();
        if (ret == null && this.size < this.maxSize) {
            SyncObjectPool syncObjectPool = this;
            synchronized (syncObjectPool) {
                if (this.size < this.maxSize) {
                    this.queue.add(this.createInstance());
                }
            }
        }
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void back(T instance) {
        if (this.maxSize >= this.queue.size()) {
            this.queue.add(instance);
            return;
        }
        throw new RuntimeException("\u8d85\u51fa\u5bb9\u91cf" + this.queue.size());
    }

    private synchronized T createInstance() {
        if (this.size < this.maxSize) {
            ++this.size;
            try {
                return this.createT.call();
            }
            catch (Exception e) {
                throw new RuntimeException("\u751f\u4ea7\u5bf9\u8c61\u62a5\u9519" + e.getMessage());
            }
        }
        throw new RuntimeException("\u961f\u5217\u4e0d\u80fd\u8d85\u8fc7" + this.maxSize);
    }

    @Override
    public synchronized void clear() {
        this.size = 0;
        this.queue.clear();
    }

    @Override
    public int getInstanceSize() {
        return this.size;
    }

    @Override
    public int getConcurrentSize() {
        return this.queue.size();
    }
}

