/*
 * Decompiled with CFR 0.152.
 */
package risesoft.data.transfer.core.util.pool;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import risesoft.data.transfer.core.util.pool.ObjectPool;

public class SimpledObjectPool<T>
implements ObjectPool<T> {
    private ConcurrentLinkedQueue<T> queues = new ConcurrentLinkedQueue();
    private volatile int size = 0;
    private int maxSize;
    private Callable<T> createT;

    public SimpledObjectPool(int maxSize, Callable<T> createT) {
        this.maxSize = maxSize;
        this.createT = createT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getInstance() {
        T ret = this.queues.poll();
        if (ret == null && this.size < this.maxSize) {
            SimpledObjectPool simpledObjectPool = this;
            synchronized (simpledObjectPool) {
                if (this.size < this.maxSize) {
                    return this.createInstance();
                }
            }
            ret = this.queues.poll();
        }
        if (ret == null) {
            throw new RuntimeException("\u6ca1\u6709\u53ef\u7528\u5bf9\u8c61:" + this.size + "maxSize:" + this.maxSize + " pool:" + this.getConcurrentSize());
        }
        return ret;
    }

    @Override
    public void back(T instance) {
        if (this.maxSize >= this.queues.size()) {
            this.queues.add(instance);
            return;
        }
        throw new RuntimeException("\u8d85\u51fa\u5bb9\u91cf" + this.queues.size());
    }

    private synchronized T createInstance() {
        if (this.size < this.maxSize) {
            ++this.size;
            try {
                return this.createT.call();
            }
            catch (Exception e) {
                throw new RuntimeException("\u751f\u4ea7\u5bf9\u8c61\u62a5\u9519" + e.getMessage());
            }
        }
        throw new RuntimeException("\u961f\u5217\u4e0d\u80fd\u8d85\u8fc7" + this.maxSize);
    }

    @Override
    public synchronized void clear() {
        this.size = 0;
        this.queues.clear();
    }

    @Override
    public int getInstanceSize() {
        return this.size;
    }

    @Override
    public int getConcurrentSize() {
        return this.queues.size();
    }
}

